package org.simantics.scl.ui.assist;

import org.eclipse.jface.fieldassist.IContentProposal;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.types.Type;

public class SCLContentProposal implements IContentProposal {

    private final String content;
    private final String name;
    private final String module;
    private final Type type;
    private final String documentation;
    
    public SCLContentProposal(SCLValue value) {
        Name n = value.getName();
        this.name = n.name;
        this.module = n.module;
//        this.content = name.substring(prefixLength-namespaceLength);
        this.content = name;
        this.type = value.getType();
        this.documentation = value.getDocumentation();
    }
    
    public SCLContentProposal(String name, String module, Type type) {
        this.name = name;
        this.module = module;
//        this.content = name.substring(prefixLength-namespaceLength);
        this.content = name;
        this.type = type;
        this.documentation = null;
    }
    
    @Override
    public String getContent() {
        return content;
    }

    @Override
    public int getCursorPosition() {
        return content.length();
    }

    @Override
    public String getLabel() {
        return name + " :: " + type + "  (" + module + ")"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
    }

    @Override
    public String getDescription() {
        return documentation;
    }

}
