# Random Numbers

This module imports part of the Java standard random number generator (`java.util.Random`) API to SCL.

The following description is an extract from [class Random Javadoc](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/Random.html):

> An instance of this class is used to generate a stream of pseudorandom numbers. The class uses a 48-bit seed, which is modified using a linear congruential formula. (See Donald Knuth, The Art of Computer Programming, Volume 2, Section 3.2.1.)
>
> If two instances of Random are created with the same seed, and the same sequence of method calls is made for each, they will generate and return identical sequences of numbers. In order to guarantee this property, particular algorithms are specified for the class Random. Java implementations must use all the algorithms shown here for the class Random, for the sake of absolute portability of Java code. However, subclasses of class Random are permitted to use other algorithms, so long as they adhere to the general contracts for all the methods.
>
> The algorithms implemented by class `Random` use a protected utility method that on each invocation can supply up to 32 pseudorandomly generated bits.
>
> Instances of `java.util.Random` are threadsafe. Instances of `java.util.Random` are not cryptographically secure.

## Generator Initialization

::value[runRandom]
::value[withSeed]

## Random Number Generation

::value[randomN]
::value[randomInteger]
::value[randomLong]
::value[randomDouble]
::value[randomFloat]
::value[randomBoolean]
