package org.simantics.scl.runtime.reporting;


public class BufferingSCLReportingHandler extends AbstractSCLReportingHandler {

    StringBuilder response = new StringBuilder();
    StringBuilder errors = new StringBuilder();
    
    @Override
    public void print(String text) {
        response.append(text).append('\n');
    }

    @Override
    public void printError(String error) {
        errors.append(error).append('\n');
    }

    @Override
    public void printCommand(String command) {
    }
    
    public boolean hasErrors() {
        return errors.length() > 0;
    }
    
    public String getErrors() {
        return errors.toString().trim();
    }
    
    public boolean hasResponse() {
        return response.length() > 0;
    }
    
    public String getResponse() {
        return response.toString().trim();
    }
}
