package org.simantics.scl.rest;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class ChunkedRequests {

	public static Response chunkedPost(Client httpClient, final String url, final File f, final int chunk_size) throws Exception {
		InputStream fileInStream = new FileInputStream(f);
		String contentDisposition = "attachment; filename=\"" + f.getName() + "\"";		

		WebTarget webTarget = prepare(httpClient, url, f, chunk_size);

		Response r = webTarget
				.request(MediaType.APPLICATION_OCTET_STREAM_TYPE)
				.header("Content-Disposition", contentDisposition)
				.header("Content-Length", (int) f.length())
				.post(Entity.entity(fileInStream, MediaType.APPLICATION_OCTET_STREAM_TYPE));
		return r;
	}

	public static Response chunkedPostAuth(Client httpClient, final String url, final File f, final int chunk_size, String authHeaderField) throws Exception {
		InputStream fileInStream = new FileInputStream(f);
		String contentDisposition = "attachment; filename=\"" + f.getName() + "\"";		

		WebTarget webTarget = prepare(httpClient, url, f, chunk_size);

		Response r = webTarget
				.request(MediaType.APPLICATION_OCTET_STREAM_TYPE)
				.header("Content-Disposition", contentDisposition)
				.header("Content-Length", (int) f.length())
				.header("Authorization", authHeaderField)
				.post(Entity.entity(fileInStream, MediaType.APPLICATION_OCTET_STREAM_TYPE));
		return r;
	}
	
	public static Response chunkedPut(Client httpClient, final String url, final File f, final int chunk_size) throws Exception {
		InputStream fileInStream = new FileInputStream(f);
		String contentDisposition = "attachment; filename=\"" + f.getName() + "\"";		

		WebTarget webTarget = prepare(httpClient, url, f, chunk_size);

		Response r = webTarget
				.request(MediaType.APPLICATION_OCTET_STREAM_TYPE)
				.header("Content-Disposition", contentDisposition)
				.header("Content-Length", (int) f.length())
				.put(Entity.entity(fileInStream, MediaType.APPLICATION_OCTET_STREAM_TYPE));
		return r;
	}

	public static Response chunkedPutAuth(Client httpClient, final String url, final File f, final int chunk_size, String authHeaderField) throws Exception {
		InputStream fileInStream = new FileInputStream(f);
		String contentDisposition = "attachment; filename=\"" + f.getName() + "\"";		

		WebTarget webTarget = prepare(httpClient, url, f, chunk_size);

		Response r = webTarget
				.request(MediaType.APPLICATION_OCTET_STREAM_TYPE)
				.header("Content-Disposition", contentDisposition)
				.header("Content-Length", (int) f.length())
				.header("Authorization", authHeaderField)
				.put(Entity.entity(fileInStream, MediaType.APPLICATION_OCTET_STREAM_TYPE));
		return r;
	}
	
	private static WebTarget prepare(Client httpClient, String url, File f, int chunk_size) {
		httpClient.property(org.glassfish.jersey.client.ClientProperties.CHUNKED_ENCODING_SIZE, chunk_size + "");
		httpClient.property(org.glassfish.jersey.client.ClientProperties.REQUEST_ENTITY_PROCESSING, "CHUNKED");

		WebTarget webTarget = httpClient.target(url);
		javax.ws.rs.client.Invocation.Builder builder = webTarget.request();
		builder.accept(MediaType.WILDCARD_TYPE);

		return webTarget;
	}
	
}
