/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.simantics.scl.compiler.types.TApply;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TForAll;
import org.simantics.scl.compiler.types.TFun;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.util.MultiFunction;
import org.simantics.scl.reflection.TypeBindingScheme;
import org.simantics.scl.reflection.TypeNotFoundException;
import org.simantics.scl.reflection.TypedValue;
import org.simantics.scl.reflection.ValueNotFoundException;
import org.simantics.scl.reflection.internal.registry.BindingRegistry;
import org.simantics.scl.runtime.function.Function;

public class ReflectionUtils {
    private static Class<?> toBoxedClass(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        throw new IllegalArgumentException("Expected a primitive type, got " + String.valueOf(clazz) + ".");
    }

    public static Class<?> getClass(TypeBindingScheme scheme, Type type) throws TypeNotFoundException {
        block7: {
            while (true) {
                if (type instanceof TCon) {
                    TCon con = (TCon)type;
                    return scheme.getClass(con);
                }
                if (type instanceof TApply) {
                    TApply apply = (TApply)type;
                    type = apply.function;
                    continue;
                }
                if (type instanceof TVar) {
                    return Object.class;
                }
                if (type instanceof TForAll) {
                    TForAll forAll = (TForAll)type;
                    type = forAll.type;
                    continue;
                }
                if (type instanceof TFun) {
                    return Function.class;
                }
                if (type instanceof TPred) {
                    return Object.class;
                }
                if (!(type instanceof TMetaVar)) break block7;
                if ((type = Types.canonical((Type)type)) instanceof TMetaVar) break;
            }
            return Object.class;
        }
        throw new IllegalArgumentException();
    }

    public static boolean isAssignableFrom(TypeBindingScheme scheme, Type to, Class<?> from) throws TypeNotFoundException {
        if (from.isPrimitive()) {
            if (from == Void.TYPE) {
                return Types.canonical((Type)to) == Types.tupleConstructor((int)0);
            }
            from = ReflectionUtils.toBoxedClass(from);
        }
        return ReflectionUtils.getClass(scheme, to).isAssignableFrom(from);
    }

    public static boolean isAssignableFrom(TypeBindingScheme scheme, Class<?> to, Type from) throws TypeNotFoundException {
        if (to.isPrimitive()) {
            if (to == Void.TYPE) {
                return Types.canonical((Type)from) == Types.tupleConstructor((int)0);
            }
            to = ReflectionUtils.toBoxedClass(to);
        }
        return to.isAssignableFrom(ReflectionUtils.getClass(scheme, from));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean isCompatible(TypeBindingScheme scheme, Type type, Method method) throws TypeNotFoundException {
        try {
            if (Modifier.isStatic(method.getModifiers())) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                MultiFunction mfun = Types.matchFunction((Type)Types.removeForAll((Type)type), (int)parameterTypes.length);
                int i = 0;
                while (i < parameterTypes.length) {
                    if (!ReflectionUtils.isAssignableFrom(scheme, parameterTypes[i], mfun.parameterTypes[i])) {
                        return false;
                    }
                    ++i;
                }
                return ReflectionUtils.isAssignableFrom(scheme, mfun.returnType, method.getReturnType());
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            MultiFunction mfun = Types.matchFunction((Type)Types.removeForAll((Type)type), (int)(parameterTypes.length + 1));
            if (!ReflectionUtils.isAssignableFrom(scheme, method.getDeclaringClass(), mfun.parameterTypes[0])) {
                return false;
            }
            int i = 0;
            while (i < parameterTypes.length) {
                if (!ReflectionUtils.isAssignableFrom(scheme, parameterTypes[i], mfun.parameterTypes[i + 1])) {
                    return false;
                }
                ++i;
            }
            return ReflectionUtils.isAssignableFrom(scheme, mfun.returnType, method.getReturnType());
        }
        catch (MatchException matchException) {
            return false;
        }
    }

    public static boolean isCompatible(TypeBindingScheme scheme, Type type, Field field) throws TypeNotFoundException {
        MultiFunction mfun;
        block4: {
            try {
                if (Modifier.isStatic(field.getModifiers())) {
                    return ReflectionUtils.isAssignableFrom(scheme, type, field.getType());
                }
                mfun = Types.matchFunction((Type)Types.removeForAll((Type)type), (int)1);
                if (ReflectionUtils.isAssignableFrom(scheme, mfun.returnType, field.getType())) break block4;
                return false;
            }
            catch (MatchException matchException) {
                return false;
            }
        }
        return ReflectionUtils.isAssignableFrom(scheme, field.getDeclaringClass(), mfun.parameterTypes[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isCompatible(TypeBindingScheme scheme, Type type, Constructor<?> constructor) throws TypeNotFoundException {
        try {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            MultiFunction mfun = Types.matchFunction((Type)Types.removeForAll((Type)type), (int)parameterTypes.length);
            int i = 0;
            while (true) {
                if (i >= parameterTypes.length) {
                    return ReflectionUtils.isAssignableFrom(scheme, mfun.returnType, constructor.getDeclaringClass());
                }
                if (!ReflectionUtils.isAssignableFrom(scheme, parameterTypes[i], mfun.parameterTypes[i])) {
                    return false;
                }
                ++i;
            }
        }
        catch (MatchException matchException) {
            return false;
        }
    }

    public static TypedValue getValue(String uri) throws ValueNotFoundException {
        int lp = uri.lastIndexOf(47);
        if (lp < -1) {
            throw new IllegalArgumentException("Invalid uri <" + uri + ">.");
        }
        return ReflectionUtils.getValue(uri.substring(0, lp), uri.substring(lp + 1));
    }

    public static TypedValue getValue(String path, String name) throws ValueNotFoundException {
        return BindingRegistry.getValue(path, name);
    }
}

