package org.simantics.scl.reflection.functions;

import java.lang.reflect.Field;

import org.simantics.scl.runtime.function.FunctionImpl1;

public class FieldAccessorFunction extends FunctionImpl1 {
    Field field;

    public FieldAccessorFunction(Field field) {
        this.field = field;
    }

    public Field getField() {
        return field;
    }
    
    @Override
    public Object apply(Object p0) {
        try {
            return field.get(p0);
        } catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
    
    @Override
    public String toString() {
        return field.getName();
    }
}
