package org.simantics.scl.osgi.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;

import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleDocumentationSource {

    private static final Logger LOGGER = LoggerFactory.getLogger(BundleDocumentationSource.class);

    public static final Charset UTF8 = Charset.forName("UTF-8");  
    
    public final String documentationName;
    public final Bundle bundle;
    public final URL url;
    
    public BundleDocumentationSource(String documentationName, Bundle bundle,
            URL url) {
        this.documentationName = documentationName;
        this.bundle = bundle;
        this.url = url;
    }

    public String getText() {
        try {
            InputStream stream = url.openStream();
            try {
                byte[] buffer = new byte[1024];
                int pos = 0;
                while(true) {
                    int count = stream.read(buffer, pos, buffer.length-pos);
                    if(count <= 0)
                        break;
                    pos += count;
                    if(pos == buffer.length)
                        buffer = Arrays.copyOf(buffer, buffer.length*2);
                }
                return new String(buffer, 0, pos, UTF8);
            } finally {
                stream.close();
            }
        } catch(IOException e) {
            LOGGER.error("Could not get text for {} at {}", documentationName, url);
            return null;
        }
    }
}
