package org.simantics.scl.db;

import org.simantics.db.Resource;

public class SCLExpressionTableEntry implements Comparable<SCLExpressionTableEntry> {

    private final String content;
    private final String location;
    private final Resource resource;

    public SCLExpressionTableEntry(String content, String position, Resource resource) {
        this.content = content;
        this.location = position;
        this.resource = resource;
    }

    public String getContent() {
        return content;
    }

    public String getLocation() {
        return location;
    }

    public Resource getResource() {
        return resource;
    }

    @Override
    public int compareTo(SCLExpressionTableEntry o) {
        return o.getContent().compareTo(content);
    }

}
