/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.types;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.internal.codegen.utils.NameMangling;
import org.simantics.scl.compiler.internal.types.HashCodeUtils;
import org.simantics.scl.compiler.internal.types.TypeHashCodeContext;
import org.simantics.scl.compiler.internal.types.ast.TConAst;
import org.simantics.scl.compiler.internal.types.ast.TypeAst;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.exceptions.KindUnificationException;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.util.Polarity;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

public final class TCon
extends Type {
    public final String module;
    public final String name;

    TCon(String module, String name) {
        if (module == null || name == null) {
            throw new NullPointerException();
        }
        this.module = module;
        this.name = name;
    }

    @Override
    public TCon replace(TVar var, Type replacement) {
        return this;
    }

    @Override
    public TypeAst toTypeAst(TypeUnparsingContext context) {
        if (this.module == "Builtin") {
            char c = this.name.charAt(0);
            if (Character.isLetter(c) || c == '(' || this.name.equals("[]")) {
                return new TConAst(this.name);
            }
            return new TConAst("(" + this.name + ")");
        }
        return new TConAst((String)(this.name.length() <= 1 ? TCon.simplifiedModuleName(this.module) + "." + this.name : this.name));
    }

    private static String simplifiedModuleName(String name) {
        int p = name.lastIndexOf(47);
        if (p == -1) {
            return name;
        }
        return name.substring(p + 1);
    }

    @Override
    public boolean equals(Object obj) {
        while (obj instanceof TMetaVar) {
            TMetaVar metaVar = (TMetaVar)obj;
            if (metaVar.ref == null) {
                return false;
            }
            obj = metaVar.ref;
        }
        return this == obj;
    }

    @Override
    public void updateHashCode(TypeHashCodeContext context) {
        context.append(System.identityHashCode(this));
    }

    @Override
    public void collectFreeVars(ArrayList<TVar> vars) {
    }

    @Override
    public void collectMetaVars(ArrayList<TMetaVar> vars) {
    }

    @Override
    public void collectMetaVars(THashSet<TMetaVar> vars) {
    }

    @Override
    public void collectEffectMetaVars(ArrayList<TMetaVar> vars) {
    }

    @Override
    public boolean isGround() {
        return true;
    }

    @Override
    public Kind inferKind(Environment context) throws KindUnificationException {
        return context.getTypeDescriptor(this).getKind();
    }

    @Override
    public Kind getKind(Environment context) {
        return context.getTypeDescriptor(this).getKind();
    }

    @Override
    public boolean containsMetaVars() {
        return false;
    }

    @Override
    public void toName(TypeUnparsingContext context, StringBuilder b) {
        b.append(NameMangling.mangle(this.name));
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    public boolean contains(TMetaVar other) {
        return false;
    }

    @Override
    public Type convertMetaVarsToVars() {
        return this;
    }

    @Override
    public void addPolarity(Polarity polarity) {
    }

    @Override
    public void collectConcreteEffects(ArrayList<TCon> concreteEffects) {
        concreteEffects.add(this);
    }

    @Override
    public Type head() {
        return this;
    }

    @Override
    public Type copySkeleton(THashMap<TMetaVar, TMetaVar> metaVarMap) {
        return this;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public int hashCode(int hash) {
        return HashCodeUtils.update(hash, System.identityHashCode(this));
    }

    @Override
    public int hashCode(int hash, TVar[] boundVars) {
        return HashCodeUtils.update(hash, System.identityHashCode(this));
    }

    @Override
    public int skeletonHashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public int skeletonHashCode(int hash) {
        return HashCodeUtils.update(hash, System.identityHashCode(this));
    }

    @Override
    public int skeletonHashCode(int hash, TVar[] boundVars) {
        return HashCodeUtils.update(hash, System.identityHashCode(this));
    }

    @Override
    public boolean equalsCanonical(Type other) {
        return this == other;
    }

    @Override
    public Type[] skeletonCanonicalChildren() {
        return EMPTY_ARRAY;
    }
}

