/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.source.repository;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.source.ModuleSource;
import org.simantics.scl.compiler.source.PrecompiledModuleSource;
import org.simantics.scl.compiler.source.repository.ModuleSourceRepository;

public class MapModuleSourceRepository
implements ModuleSourceRepository {
    THashMap<String, ModuleSource> modules = new THashMap();
    THashMap<String, String> documentations = new THashMap();
    THashMap<String, ArrayList<UpdateListener>> listeners = new THashMap();

    public MapModuleSourceRepository() {
    }

    public MapModuleSourceRepository(ModuleSource ... descriptors) {
        ModuleSource[] moduleSourceArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleSource descriptor = moduleSourceArray[n2];
            this.addModuleDescriptor(descriptor);
            ++n2;
        }
    }

    public MapModuleSourceRepository(Module ... modules) {
        Module[] moduleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            Module module = moduleArray[n2];
            this.addModule(module);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModuleDescriptor(ModuleSource descriptor) {
        this.modules.put((Object)descriptor.getModuleName(), (Object)descriptor);
        THashMap<String, ArrayList<UpdateListener>> tHashMap = this.listeners;
        synchronized (tHashMap) {
            ArrayList list = (ArrayList)this.listeners.get((Object)descriptor.getModuleName());
            if (list != null) {
                UpdateListener[] updateListenerArray = list.toArray(new UpdateListener[list.size()]);
                int n = updateListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    UpdateListener listener = updateListenerArray[n2];
                    listener.notifyAboutUpdate();
                    ++n2;
                }
            }
        }
    }

    public void addModule(Module module) {
        this.addModuleDescriptor(new PrecompiledModuleSource(module));
    }

    public void addDocumentation(String documentationName, String documentation) {
        this.documentations.put((Object)documentationName, (Object)documentation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModuleSource getModuleSource(final String moduleName, UpdateListener listener) {
        if (listener != null) {
            THashMap<String, ArrayList<UpdateListener>> tHashMap = this.listeners;
            synchronized (tHashMap) {
                ArrayList<UpdateListener> list = (ArrayList<UpdateListener>)this.listeners.get((Object)moduleName);
                if (list == null) {
                    list = new ArrayList<UpdateListener>(2);
                    this.listeners.put((Object)moduleName, list);
                }
                list.add(listener);
            }
            listener.addObservable(new UpdateListener.Observable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void removeListener(UpdateListener listener) {
                    THashMap<String, ArrayList<UpdateListener>> tHashMap = MapModuleSourceRepository.this.listeners;
                    synchronized (tHashMap) {
                        ArrayList list = (ArrayList)MapModuleSourceRepository.this.listeners.get((Object)moduleName);
                        if (list != null) {
                            list.remove(listener);
                            if (list.isEmpty()) {
                                MapModuleSourceRepository.this.listeners.remove((Object)moduleName);
                            }
                        }
                    }
                }
            });
        }
        return (ModuleSource)this.modules.get((Object)moduleName);
    }

    @Override
    public Collection<String> getModuleNames() {
        return this.modules.keySet();
    }

    @Override
    public void forAllModules(TObjectProcedure<String> procedure) {
        this.modules.forEachKey(procedure);
    }

    @Override
    public String getDocumentation(String documentationName) {
        return (String)this.documentations.get((Object)documentationName);
    }

    @Override
    public Collection<String> getDocumentationNames() {
        return this.documentations.keySet();
    }
}

