/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.module.coverage;

import gnu.trove.map.hash.THashMap;
import java.io.PrintStream;
import java.util.Arrays;
import org.simantics.scl.compiler.module.coverage.AbstractCoverage;
import org.simantics.scl.compiler.module.coverage.CoverageUtils;
import org.simantics.scl.compiler.module.coverage.FunctionCoverage;

public class ModuleCoverage
extends AbstractCoverage {
    public final THashMap<String, FunctionCoverage> functionCoverages;
    public final int totalFunctionCount;
    public final int coveredFunctionCount;
    public final double functionCoverage;

    public ModuleCoverage(String moduleName, THashMap<String, FunctionCoverage> functionCoverages, int totalCodeSize, int coveredCodeSize, int totalFunctionCount, int coveredFunctionCount) {
        super(moduleName, totalCodeSize, coveredCodeSize);
        this.functionCoverages = functionCoverages;
        this.totalFunctionCount = totalFunctionCount;
        this.coveredFunctionCount = coveredFunctionCount;
        this.functionCoverage = CoverageUtils.safeDiv(coveredFunctionCount, totalFunctionCount);
    }

    public void print(PrintStream s) {
        s.println("Code coverage: " + this.toPercent(this.getCoverage()) + " (" + this.getCoveredCodeSize() + " / " + this.getTotalCodeSize() + ")");
        s.println("Function coverage: " + this.toPercent(this.functionCoverage) + " (" + this.coveredFunctionCount + " / " + this.totalFunctionCount + ")");
        Object[] functionNames = this.functionCoverages.keySet().toArray(new String[this.functionCoverages.size()]);
        Arrays.sort(functionNames);
        Object[] objectArray = functionNames;
        int n = functionNames.length;
        int n2 = 0;
        while (n2 < n) {
            Object functionName = objectArray[n2];
            FunctionCoverage fCov = (FunctionCoverage)this.functionCoverages.get(functionName);
            s.println("    " + (String)functionName + ": " + this.toPercent(fCov.getCoverage()) + " (" + fCov.coveredCodeSize + " / " + fCov.totalCodeSize + ")");
            ++n2;
        }
    }
}

