/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.ssa;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;
import java.util.ArrayList;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.constants.JavaStaticField;
import org.simantics.scl.compiler.constants.JavaStaticMethod;
import org.simantics.scl.compiler.constants.SCLConstant;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAClosure;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.internal.codegen.ssa.StaticField;
import org.simantics.scl.compiler.internal.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.internal.codegen.utils.ClassBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.CodeBuildingException;
import org.simantics.scl.compiler.internal.codegen.utils.Constants;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilderBase;
import org.simantics.scl.compiler.internal.codegen.utils.ModuleBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.NameMangling;
import org.simantics.scl.compiler.internal.codegen.utils.PrintingContext;
import org.simantics.scl.compiler.internal.codegen.utils.SSALambdaLiftingContext;
import org.simantics.scl.compiler.internal.codegen.utils.SSASimplificationContext;
import org.simantics.scl.compiler.internal.codegen.utils.SSAValidationContext;
import org.simantics.scl.compiler.top.SCLCompilerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSAModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSAModule.class);
    THashMap<Name, SCLConstant> functions = new THashMap();
    ArrayList<StaticField> staticFields = new ArrayList();
    public ArrayList<SSAClosure> closuresToGenerate = new ArrayList();

    public void put(Name name, SCLConstant function) {
        this.functions.put((Object)name, (Object)function);
    }

    public SCLConstant get(Name name) {
        return (SCLConstant)this.functions.get((Object)name);
    }

    public String toString() {
        final StringBuilder b = new StringBuilder();
        this.functions.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<Name, SCLConstant>(){

            public boolean execute(Name name, SCLConstant function) {
                b.append(name.name);
                b.append(" :: ");
                b.append(function.getType());
                b.append('\n');
                if (function.isPrivate()) {
                    b.append("PRIVATE ");
                }
                b.append(name);
                b.append(" =\n");
                PrintingContext context = new PrintingContext();
                context.indent();
                function.getDefinition().toString(context);
                b.append(context.toString());
                return true;
            }
        });
        return b.toString();
    }

    public void validate(SSAValidationContext context) {
        for (SCLConstant function : this.functions.values()) {
            try {
                function.getDefinition().validate(context);
            }
            catch (RuntimeException e) {
                LOGGER.info("-- VALIDATE " + String.valueOf(function.getName()) + " ----------------");
                PrintingContext printingContext = new PrintingContext();
                printingContext.setErrorMarker(context.errorMarker);
                function.getDefinition().toString(printingContext);
                LOGGER.info(printingContext.toString());
                throw e;
            }
        }
    }

    public void validate() {
        SSAValidationContext context = new SSAValidationContext();
        this.validate(context);
    }

    public boolean simplify(Environment environment, int phase) {
        SSASimplificationContext context = new SSASimplificationContext(this, environment, phase);
        SCLConstant[] sCLConstantArray = this.functions.values().toArray(new SCLConstant[this.functions.size()]);
        int n = sCLConstantArray.length;
        int n2 = 0;
        while (n2 < n) {
            SCLConstant function = sCLConstantArray[n2];
            if (this.functions.containsKey((Object)function.getName())) {
                if (function.isPrivate() && function.hasNoOccurences()) {
                    function.getDefinition().destroy();
                    this.functions.remove((Object)function.getName());
                    context.markModified("SSAModule.dead-function " + String.valueOf(function.getName()));
                } else {
                    function.simplify(context);
                }
            }
            ++n2;
        }
        return context.didModify();
    }

    public void generateCode(final ModuleBuilder moduleBuilder) throws CodeBuildingException {
        final String moduleClassName = moduleBuilder.getNamingPolicy().getModuleClassName();
        if (SCLCompilerConfiguration.TRACE_METHOD_CREATION) {
            LOGGER.info("Create class " + moduleClassName);
        }
        final ClassBuilder classFile = new ClassBuilder(moduleBuilder, 1, moduleClassName, "java/lang/Object", new String[0]);
        classFile.setSourceFile(moduleBuilder.getNamingPolicy().getModuleName());
        this.functions.forEachValue((TObjectProcedure)new TObjectProcedure<SCLConstant>(){

            public boolean execute(SCLConstant function) {
                if (function.getBase() == null) {
                    TypeDesc typeDesc;
                    Name name = function.getName();
                    SSAFunction definition = function.getDefinition();
                    String javaName = NameMangling.mangle(name.name);
                    if (definition.getArity() == 0 && (typeDesc = moduleBuilder.getJavaTypeTranslator().toTypeDesc(definition.getReturnType())) != TypeDesc.VOID) {
                        String initClassName = moduleBuilder.getNamingPolicy().getFreshClosureClassName();
                        function.setBase(new JavaStaticField(initClassName, "VALUE", definition.getReturnType(), -1));
                        ClassBuilder initClass = new ClassBuilder(moduleBuilder, 1, initClassName, "java/lang/Object", new String[0]);
                        initClass.addField(25, "VALUE", typeDesc);
                        MethodBuilderBase classInitializer = initClass.addInitializerBase();
                        classInitializer.invokeStatic(moduleClassName, javaName, typeDesc, Constants.EMPTY_TYPEDESC_ARRAY);
                        classInitializer.storeStaticField(initClassName, "VALUE", typeDesc);
                        classInitializer.returnVoid();
                        classInitializer.finish();
                        moduleBuilder.addClass(initClass);
                        return true;
                    }
                    function.setBase(new JavaStaticMethod(moduleClassName, javaName, definition.getEffect(), definition.getTypeParameters(), definition.getReturnType(), definition.getParameterTypes()));
                }
                return true;
            }
        });
        this.functions.forEachValue((TObjectProcedure)new TObjectProcedure<SCLConstant>(){

            public boolean execute(SCLConstant function) {
                JavaTypeTranslator javaTypeTranslator = moduleBuilder.getJavaTypeTranslator();
                SSAFunction def = function.getDefinition();
                MethodBuilder mb = classFile.addMethod(9, NameMangling.mangle(function.getName().name), javaTypeTranslator.getTypeDesc(def.getReturnCont()), JavaTypeTranslator.filterVoid(javaTypeTranslator.getTypeDescs(def.getParameters())));
                def.generateCode(mb);
                mb.finish();
                return true;
            }
        });
        JavaTypeTranslator javaTypeTranslator = moduleBuilder.getJavaTypeTranslator();
        for (StaticField tuple : this.staticFields) {
            classFile.addField(9, tuple.name, javaTypeTranslator.toTypeDesc(tuple.type));
        }
        classFile.addDefaultConstructor();
        moduleBuilder.addClass(classFile);
        for (SSAClosure closure : this.closuresToGenerate) {
            closure.generateCode(moduleBuilder);
        }
    }

    public void markGenerateOnFly() {
        this.functions.forEachValue((TObjectProcedure)new TObjectProcedure<SCLConstant>(){

            public boolean execute(SCLConstant func) {
                func.getDefinition().markGenerateOnFly();
                return true;
            }
        });
    }

    public void addStaticField(StaticField tuple) {
        this.staticFields.add(tuple);
    }

    public SCLConstant remove(Name name) {
        return (SCLConstant)this.functions.remove((Object)name);
    }

    public void lambdaLift(ErrorLog errorLog) {
        SSALambdaLiftingContext context = new SSALambdaLiftingContext(this, errorLog);
        SCLConstant[] sCLConstantArray = this.functions.values().toArray(new SCLConstant[this.functions.size()]);
        int n = sCLConstantArray.length;
        int n2 = 0;
        while (n2 < n) {
            SCLConstant function = sCLConstantArray[n2];
            context.setParentName(function.getName());
            function.getDefinition().lambdaLift(context);
            ++n2;
        }
    }

    public void saveInlinableDefinitions() {
        for (SCLConstant function : this.functions.values()) {
            function.saveInlinableDefinition();
        }
    }

    public void cleanup() {
        for (SSAClosure closure : this.closuresToGenerate) {
            closure.cleanup();
        }
        for (SCLConstant constant : this.functions.values()) {
            constant.cleanup();
        }
    }
}

