/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.errors;

import java.util.ArrayList;
import java.util.Collections;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.compiler.errors.ErrorSeverity;

public class ErrorLog {
    ArrayList<CompilationError> errors = new ArrayList();
    int errorCount;
    long exceptionPosition = 9223372034707292160L;

    public void log(String message) {
        this.log(new CompilationError(message));
    }

    public void log(CompilationError error) {
        this.errors.add(error);
        if (error.severity != ErrorSeverity.WARNING) {
            ++this.errorCount;
        }
    }

    public void log(long locatable, String description) {
        this.log(new CompilationError(locatable, description));
    }

    public void logWarning(long locatable, String description) {
        this.log(new CompilationError(locatable, description, ErrorSeverity.WARNING));
    }

    public void log(Exception e) {
        long location = 9223372034707292160L;
        if (e instanceof InternalCompilerError) {
            location = ((InternalCompilerError)e).location;
        }
        if (location == 9223372034707292160L) {
            location = this.exceptionPosition;
        }
        this.log(new CompilationError(location, e));
    }

    public void log(long location, Exception e) {
        this.log(new CompilationError(location, e));
    }

    public boolean hasNoErrors() {
        return this.errorCount == 0;
    }

    public boolean hasErrors() {
        return this.errorCount > 0;
    }

    public boolean hasErrorsOrWarnings() {
        return !this.errors.isEmpty();
    }

    public CompilationError[] getErrors() {
        Collections.sort(this.errors);
        return this.errors.toArray(new CompilationError[this.errors.size()]);
    }

    public void setExceptionPosition(long exceptionPosition) {
        if (this.exceptionPosition == 9223372034707292160L) {
            this.exceptionPosition = exceptionPosition;
        }
    }

    public String getErrorsAsString() {
        Collections.sort(this.errors);
        StringBuilder b = new StringBuilder();
        for (CompilationError error : this.errors) {
            b.append(error.description).append('\n');
        }
        return b.toString();
    }

    public String toString() {
        return this.getErrorsAsString();
    }

    public int getErrorCount() {
        return this.errorCount;
    }
}

