/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.errors;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.simantics.scl.compiler.errors.ErrorSeverity;

public class CompilationError
implements Comparable<CompilationError> {
    public static final CompilationError[] EMPTY_ARRAY = new CompilationError[0];
    public final long location;
    public final String description;
    public final ErrorSeverity severity;

    public CompilationError(long location, String description, ErrorSeverity severity) {
        if (description == null) {
            throw new NullPointerException();
        }
        this.location = location;
        this.description = description;
        this.severity = severity;
    }

    public CompilationError(long location, String description) {
        this(location, description, ErrorSeverity.ERROR);
    }

    public CompilationError(long location, Exception exception) {
        this(location, CompilationError.exceptionToString(exception));
    }

    public CompilationError(String description) {
        this(9223372034707292160L, description);
    }

    public CompilationError(Exception exception) {
        this(9223372034707292160L, exception);
    }

    private static String exceptionToString(Exception e) {
        StringWriter w = new StringWriter();
        e.printStackTrace(new PrintWriter(w));
        return w.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (int)(this.location ^ this.location >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompilationError other = (CompilationError)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return this.location == other.location;
    }

    @Override
    public int compareTo(CompilationError o) {
        if (this.location < o.location) {
            return -1;
        }
        if (this.location > o.location) {
            return 1;
        }
        return this.description.compareTo(o.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("CompilationError: \"").append(this.description);
        if (this.location != 9223372034707292160L) {
            sb.append("\" at location ").append(this.location).toString();
        }
        return sb.toString();
    }
}

