/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.java;

import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.constants.JavaMethod;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EExternalConstant;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.macros.MacroRule;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.internal.codegen.types.StandardTypeConstructor;
import org.simantics.scl.compiler.module.ConcreteModule;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TFun;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class LoggingModule
extends ConcreteModule {
    private static final String[] LOGGING_METHODS = new String[]{"trace", "debug", "info", "warn", "error"};
    public static final TCon Throwable = Types.con("Prelude", "Throwable");

    public LoggingModule() {
        super("LoggingJava");
        final TCon Logger2 = Types.con(this.getName(), "Logger");
        StandardTypeConstructor loggerConstructor = new StandardTypeConstructor(Logger2, Kinds.STAR, TypeDesc.forClass(Logger.class));
        loggerConstructor.external = true;
        this.addTypeDescriptor("Logger", loggerConstructor);
        TCon Marker2 = Types.con(this.getName(), "Marker");
        StandardTypeConstructor markerConstructor = new StandardTypeConstructor(Marker2, Kinds.STAR, TypeDesc.forClass(Marker.class));
        markerConstructor.external = true;
        this.addTypeDescriptor("Marker", markerConstructor);
        TFun isEnabledType = Types.functionE(Types.PUNIT, (Type)Types.PROC, (Type)Types.BOOLEAN);
        TFun loggingType = Types.functionE(Types.STRING, (Type)Types.PROC, (Type)Types.UNIT);
        Type loggingTypeWithMarker = Types.functionE(new Type[]{Marker2, Types.STRING}, (Type)Types.PROC, (Type)Types.UNIT);
        Type loggingTypeWithException = Types.functionE(new Type[]{Types.STRING, Throwable}, (Type)Types.PROC, (Type)Types.UNIT);
        Type loggingTypeWithMarkerAndException = Types.functionE(new Type[]{Marker2, Types.STRING, Throwable}, (Type)Types.PROC, (Type)Types.UNIT);
        String[] stringArray = LOGGING_METHODS;
        int n = LOGGING_METHODS.length;
        int n2 = 0;
        while (n2 < n) {
            String methodName = stringArray[n2];
            String completeMethodName = LoggingModule.generateIsEnabledName(methodName);
            final JavaMethod javaMethod = new JavaMethod(false, "org/slf4j/Logger", completeMethodName, (Type)Types.PROC, (Type)Types.BOOLEAN, Logger2);
            SCLValue value = new SCLValue(Name.create(this.getName(), completeMethodName));
            value.setType(isEnabledType);
            value.setMacroRule(new MacroRule(){

                @Override
                public Expression apply(SimplificationContext context, Type[] typeParameters, EApply apply) {
                    String identifier = LoggingModule.resolveModuleIdentifier(context.getCompilationContext());
                    apply.set(new ELiteral(javaMethod), new Expression[]{new EExternalConstant(LoggerFactory.getLogger((String)identifier), Logger2)});
                    return apply;
                }
            });
            this.addValue(value);
            final JavaMethod javaMethod2 = new JavaMethod(false, "org/slf4j/Logger", methodName, (Type)Types.PROC, (Type)Types.UNIT, Logger2, Types.STRING);
            SCLValue value2 = new SCLValue(Name.create(this.getName(), methodName));
            value2.setType(loggingType);
            value2.setMacroRule(new MacroRule(){

                @Override
                public Expression apply(SimplificationContext context, Type[] typeParameters, EApply apply) {
                    String identifier = LoggingModule.resolveModuleIdentifier(context.getCompilationContext());
                    apply.set(new ELiteral(javaMethod2), new Expression[]{new EExternalConstant(LoggerFactory.getLogger((String)identifier), Logger2), apply.parameters[0]});
                    return apply;
                }
            });
            this.addValue(value2);
            javaMethod2 = new JavaMethod(false, "org/slf4j/Logger", methodName, (Type)Types.PROC, (Type)Types.UNIT, Logger2, Types.STRING, Throwable);
            value2 = new SCLValue(Name.create(this.getName(), methodName + "E"));
            value2.setType(loggingTypeWithException);
            value2.setMacroRule(new MacroRule(){

                @Override
                public Expression apply(SimplificationContext context, Type[] typeParameters, EApply apply) {
                    String identifier = LoggingModule.resolveModuleIdentifier(context.getCompilationContext());
                    apply.set(new ELiteral(javaMethod2), new Expression[]{new EExternalConstant(LoggerFactory.getLogger((String)identifier), Logger2), apply.parameters[0], apply.parameters[1]});
                    return apply;
                }
            });
            this.addValue(value2);
            javaMethod2 = new JavaMethod(false, "org/slf4j/Logger", methodName, (Type)Types.PROC, (Type)Types.UNIT, Logger2, Marker2, Types.STRING);
            value2 = new SCLValue(Name.create(this.getName(), methodName + "M"));
            value2.setType(loggingTypeWithMarker);
            value2.setMacroRule(new MacroRule(){

                @Override
                public Expression apply(SimplificationContext context, Type[] typeParameters, EApply apply) {
                    String identifier = LoggingModule.resolveModuleIdentifier(context.getCompilationContext());
                    apply.set(new ELiteral(javaMethod2), new Expression[]{new EExternalConstant(LoggerFactory.getLogger((String)identifier), Logger2), apply.parameters[0], apply.parameters[1]});
                    return apply;
                }
            });
            this.addValue(value2);
            javaMethod2 = new JavaMethod(false, "org/slf4j/Logger", methodName, (Type)Types.PROC, (Type)Types.UNIT, Logger2, Marker2, Types.STRING, Throwable);
            value2 = new SCLValue(Name.create(this.getName(), methodName + "ME"));
            value2.setType(loggingTypeWithMarkerAndException);
            value2.setMacroRule(new MacroRule(){

                @Override
                public Expression apply(SimplificationContext context, Type[] typeParameters, EApply apply) {
                    String identifier = LoggingModule.resolveModuleIdentifier(context.getCompilationContext());
                    apply.set(new ELiteral(javaMethod2), new Expression[]{new EExternalConstant(LoggerFactory.getLogger((String)identifier), Logger2), apply.parameters[0], apply.parameters[1], apply.parameters[2]});
                    return apply;
                }
            });
            this.addValue(value2);
            ++n2;
        }
        this.setParentClassLoader(LoggerFactory.class.getClassLoader());
    }

    private static String generateIsEnabledName(String level) {
        return "is" + LoggingModule.capitalizeFirstCharacter(level) + "Enabled";
    }

    private static String capitalizeFirstCharacter(String input) {
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    private static String resolveModuleIdentifier(CompilationContext context) {
        String identifier;
        ConcreteModule module = context.module;
        if (module != null) {
            String moduleName = module.getName();
            if (moduleName.startsWith("http://")) {
                moduleName = moduleName.substring("http://".length());
            }
            identifier = moduleName.replaceAll("/", ".");
        } else {
            identifier = CommandSession.class.getName();
        }
        return identifier;
    }
}

