/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.constants.StringInterpolation;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.expressions.ASTExpression;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;

public class EStringLiteral
extends ASTExpression {
    public String[] strings;
    public Expression[] expressions;

    public EStringLiteral(String[] strings, Expression[] expressions) {
        this.strings = strings;
        this.expressions = expressions;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        Expression[] components = new Expression[this.expressions.length];
        SCLValue showForPrinting = context.getEnvironment().getValue(Names.Prelude_showForPrinting);
        int i = 0;
        while (i < this.expressions.length) {
            components[i] = new EApply((Expression)new EConstant(showForPrinting), this.expressions[i]);
            ++i;
        }
        EApply result = new EApply((Expression)new ELiteral(new StringInterpolation(this.strings)), components);
        result.setLocationDeep(this.location);
        return result.resolve(context);
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            Expression[] expressionArray = this.expressions;
            int n = this.expressions.length;
            int n2 = 0;
            while (n2 < n) {
                Expression expression = expressionArray[n2];
                expression.setLocationDeep(loc);
                ++n2;
            }
        }
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        int i = 0;
        while (i < this.expressions.length) {
            this.expressions[i] = this.expressions[i].resolveAsPattern(context);
            ++i;
        }
        if (this.expressions.length > 1) {
            context.getErrorLog().log(this.location, "String interpolation can be a pattern only if has one hole.");
            return new EError();
        }
        EApply result = new EApply((Expression)new ELiteral(new StringInterpolation(this.strings)), this.expressions);
        result.setLocationDeep(this.location);
        return result;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

