/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import java.util.ArrayList;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Case;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLet;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.GuardedExpressionGroup;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.ssa.exits.Throw;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.elaboration.matching.PatternMatchingCompiler;
import org.simantics.scl.compiler.internal.elaboration.matching.Row;
import org.simantics.scl.compiler.internal.parsing.Symbol;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class EMatch
extends Expression {
    public Expression[] scrutinee;
    public Case[] cases;

    public EMatch(Expression[] scrutinee, Case ... cases) {
        this.scrutinee = scrutinee;
        this.cases = cases;
    }

    public EMatch(Expression scrutinee, Case ... cases) {
        this(new Expression[]{scrutinee}, cases);
    }

    public EMatch(long loc, Expression[] scrutinee, Case ... cases) {
        super(loc);
        this.scrutinee = scrutinee;
        this.cases = cases;
    }

    @Override
    protected void updateType() {
        this.setType(this.cases[0].value.getType());
    }

    @Override
    public IVal toVal(CompilationContext context, CodeWriter w) {
        ArrayList<Row> rows = new ArrayList<Row>(this.cases.length);
        Case[] caseArray = this.cases;
        int n = this.cases.length;
        int n2 = 0;
        while (n2 < n) {
            Case case_ = caseArray[n2];
            rows.add(new Row(case_.patterns, case_.value));
            ++n2;
        }
        IVal[] scrutineeVals = new IVal[this.scrutinee.length];
        int i = 0;
        while (i < this.scrutinee.length) {
            scrutineeVals[i] = this.scrutinee[i].toVal(context, w);
            ++i;
        }
        CodeWriter joinPoint = w.createBlock(this.getType());
        CodeWriter failurePoint = w.createBlock();
        PatternMatchingCompiler.split(this.location, w, context, scrutineeVals, joinPoint.getContinuation(), failurePoint.getContinuation(), rows);
        failurePoint.throw_(this.location, Throw.MatchingException, "Matching failure at: " + this.toString());
        w.continueAs(joinPoint);
        return w.getParameters()[0];
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        int i = 0;
        while (i < this.scrutinee.length) {
            this.scrutinee[i] = this.scrutinee[i].simplify(context);
            ++i;
        }
        Case[] caseArray = this.cases;
        int n = this.cases.length;
        int n2 = 0;
        while (n2 < n) {
            Case case_ = caseArray[n2];
            case_.simplify(context);
            ++n2;
        }
        if (this.cases.length == 1 && this.scrutinee.length == 1) {
            Case case_ = this.cases[0];
            Expression pattern = case_.patterns[0];
            if (case_.patterns[0] instanceof EVariable && !(case_.value instanceof GuardedExpressionGroup)) {
                Variable var = ((EVariable)pattern).variable;
                return new ESimpleLet(var, this.scrutinee[0], case_.value);
            }
        }
        return this;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        int i = 0;
        while (i < this.scrutinee.length) {
            this.scrutinee[i] = this.scrutinee[i].resolve(context);
            ++i;
        }
        Case[] caseArray = this.cases;
        int n = this.cases.length;
        int n2 = 0;
        while (n2 < n) {
            Case case_ = caseArray[n2];
            case_.resolve(context);
            ++n2;
        }
        return this;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            Symbol[] symbolArray = this.cases;
            int n = this.cases.length;
            int n2 = 0;
            while (n2 < n) {
                Case case_ = symbolArray[n2];
                case_.setLocationDeep(loc);
                ++n2;
            }
            symbolArray = this.scrutinee;
            n = this.scrutinee.length;
            n2 = 0;
            while (n2 < n) {
                Symbol e = symbolArray[n2];
                ((Expression)e).setLocationDeep(loc);
                ++n2;
            }
        }
    }

    @Override
    public Expression replace(ReplaceContext context) {
        Expression[] newScrutinee = new Expression[this.scrutinee.length];
        int i = 0;
        while (i < this.scrutinee.length) {
            newScrutinee[i] = this.scrutinee[i].replace(context);
            ++i;
        }
        Case[] newCases = new Case[this.cases.length];
        int i2 = 0;
        while (i2 < this.cases.length) {
            newCases[i2] = this.cases[i2].replace(context);
            ++i2;
        }
        return new EMatch(this.getLocation(), newScrutinee, newCases);
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        Type[] scrutineeTypes = new Type[this.scrutinee.length];
        int i = 0;
        while (i < this.scrutinee.length) {
            this.scrutinee[i] = this.scrutinee[i].checkType(context, Types.metaVar(Kinds.STAR));
            scrutineeTypes[i] = this.scrutinee[i].getType();
            ++i;
        }
        Case[] caseArray = this.cases;
        int n = this.cases.length;
        int n2 = 0;
        while (n2 < n) {
            Case case_ = caseArray[n2];
            case_.checkType(context, scrutineeTypes, requiredType);
            ++n2;
        }
        this.setType(requiredType);
        return this;
    }

    @Override
    public Expression checkIgnoredType(TypingContext context) {
        Type[] scrutineeTypes = new Type[this.scrutinee.length];
        int i = 0;
        while (i < this.scrutinee.length) {
            this.scrutinee[i] = this.scrutinee[i].checkType(context, Types.metaVar(Kinds.STAR));
            scrutineeTypes[i] = this.scrutinee[i].getType();
            ++i;
        }
        Case[] caseArray = this.cases;
        int n = this.cases.length;
        int n2 = 0;
        while (n2 < n) {
            Case case_ = caseArray[n2];
            case_.checkIgnoredType(context, scrutineeTypes);
            ++n2;
        }
        this.setType(Types.UNIT);
        return this;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public Expression[] getScrutinee() {
        return this.scrutinee;
    }

    public Case[] getCases() {
        return this.cases;
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public int getSyntacticFunctionArity() {
        int result = 0;
        Case[] caseArray = this.cases;
        int n = this.cases.length;
        int n2 = 0;
        while (n2 < n) {
            Case case_ = caseArray[n2];
            result = Math.max(result, case_.value.getSyntacticFunctionArity());
            ++n2;
        }
        return result;
    }
}

