/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import java.util.ArrayList;
import org.simantics.scl.compiler.elaboration.chr.CHRRule;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.chr.ast.CHRQueryTranslationMode;
import org.simantics.scl.compiler.elaboration.chr.translation.CHRTranslation;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.expressions.ASTExpression;
import org.simantics.scl.compiler.elaboration.expressions.ECHRRuleset;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.EPreLet;
import org.simantics.scl.compiler.elaboration.expressions.EPreRuleset;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.block.BlockType;
import org.simantics.scl.compiler.elaboration.expressions.block.CHRStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.ConstraintStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.GuardStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.IncludeStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.RuleStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.Statement;
import org.simantics.scl.compiler.elaboration.expressions.block.StatementGroup;
import org.simantics.scl.compiler.errors.Locations;

public class EBlock
extends ASTExpression {
    public ArrayList<Statement> statements = new ArrayList();
    BlockType blockType = BlockType.Normal;

    public void setBlockType(BlockType blockType) {
        this.blockType = blockType;
    }

    public void addStatement(Statement statement) {
        this.statements.add(statement);
    }

    public ArrayList<Statement> getStatements() {
        return this.statements;
    }

    public Statement getFirst() {
        return this.statements.get(0);
    }

    public Statement getLast() {
        return this.statements.get(this.statements.size() - 1);
    }

    @Override
    public Expression resolve(TranslationContext context) {
        if (this.statements.isEmpty()) {
            context.getErrorLog().log(this.location, "Block should not be empty.");
            return new EError(this.location);
        }
        int i = this.statements.size() - 1;
        Statement last = this.statements.get(i);
        if (!(last instanceof GuardStatement)) {
            context.getErrorLog().log(last.location, "Block should end with an expression");
            return new EError(this.location);
        }
        Expression in = ((GuardStatement)last).value;
        while (--i >= 0) {
            Statement cur = this.statements.get(i);
            StatementGroup group = cur.getStatementGroup();
            if (group == null) {
                in = cur.toExpression(context, this.blockType, in);
                continue;
            }
            int endId = i + 1;
            while (i > 0 && this.statements.get(i - 1).getStatementGroup() == group) {
                --i;
            }
            switch (group) {
                case LetFunction: {
                    in = this.extractLet(i, endId, in);
                    break;
                }
                case Rule: {
                    in = this.extractRules(i, endId, in);
                    break;
                }
                case CHR: {
                    CHRRuleset ruleset = this.extractCHRRules(context, i, endId);
                    long location = Locations.combine(ruleset.location, in.location);
                    in = new ECHRRuleset(ruleset, in);
                    in.location = location;
                }
            }
        }
        return in.resolve(context);
    }

    private Expression extractRules(int begin, int end, Expression in) {
        return new EPreRuleset(this.statements.subList(begin, end).toArray(new RuleStatement[end - begin]), in);
    }

    private CHRRuleset extractCHRRules(TranslationContext context, int begin, int end) {
        CHRRuleset ruleset = new CHRRuleset();
        ruleset.location = Locations.combine(this.statements.get((int)begin).location, this.statements.get((int)(end - 1)).location);
        int i = begin;
        while (i < end) {
            Statement statement = this.statements.get(i);
            if (statement instanceof CHRStatement) {
                CHRStatement chrStatement = (CHRStatement)statement;
                ruleset.addRule(new CHRRule(chrStatement.location, chrStatement.head.translate(context, CHRQueryTranslationMode.RULE_HEAD), chrStatement.body.translate(context, CHRQueryTranslationMode.RULE_BODY)));
            } else if (statement instanceof ConstraintStatement) {
                ruleset.addConstraint(CHRTranslation.convertConstraintStatement(context, (ConstraintStatement)statement));
            } else if (statement instanceof IncludeStatement) {
                ruleset.includes.add((IncludeStatement)statement);
            } else {
                context.getErrorLog().log(statement.location, "Invalid CHR statement.");
            }
            ++i;
        }
        return ruleset;
    }

    public CHRRuleset extractCHRRules(TranslationContext context) {
        return this.extractCHRRules(context, 0, this.statements.size());
    }

    private Expression extractLet(int begin, int end, Expression in) {
        return new EPreLet(this.statements.subList(begin, end), in);
    }

    public static Expression create(ArrayList<Expression> statements) {
        EBlock block = new EBlock();
        for (Expression statement : statements) {
            block.addStatement(new GuardStatement(statement));
        }
        return block;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            for (Statement statement : this.statements) {
                statement.setLocationDeep(loc);
            }
        }
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public int getSyntacticFunctionArity() {
        if (this.blockType != BlockType.Normal) {
            return 0;
        }
        Statement lastStatement = this.statements.get(this.statements.size() - 1);
        if (!(lastStatement instanceof GuardStatement)) {
            return 0;
        }
        return ((GuardStatement)lastStatement).value.getSyntacticFunctionArity();
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

