/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.chr;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.chr.CHRRelation;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;
import org.simantics.scl.compiler.elaboration.chr.relations.ExternalCHRRelation;
import org.simantics.scl.compiler.elaboration.chr.relations.SpecialCHRRelation;
import org.simantics.scl.compiler.elaboration.chr.relations.UnresolvedCHRRelation;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.ERecord;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.printing.ExpressionToStringVisitor;
import org.simantics.scl.compiler.elaboration.expressions.records.FieldAssignment;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.internal.parsing.Symbol;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class CHRLiteral
extends Symbol {
    public CHRRelation relation;
    public Type[] typeParameters;
    public Expression[] parameters;
    public FieldAssignment[] fields;
    public Expression[] typeConstraintEvidenceParameters;
    public boolean killAfterMatch;
    public boolean negated;
    public boolean passive = true;

    public CHRLiteral(long location, CHRRelation relation, Expression[] parameters, boolean killAfterMatch, boolean negated) {
        this.location = location;
        this.relation = relation;
        this.parameters = parameters;
        this.killAfterMatch = killAfterMatch;
        this.negated = negated;
    }

    public void resolve(TranslationContext context) {
        if (this.relation == SpecialCHRRelation.ASSIGN) {
            this.parameters[1] = this.parameters[1].resolve(context);
            this.parameters[0] = this.parameters[0].resolveAsPattern(context);
            return;
        }
        if (this.parameters != null) {
            int i = 0;
            while (i < this.parameters.length) {
                this.parameters[i] = this.parameters[i].resolve(context);
                ++i;
            }
        }
        if (this.relation instanceof UnresolvedCHRRelation) {
            UnresolvedCHRRelation unresolved = (UnresolvedCHRRelation)this.relation;
            CHRConstraint constraint = context.resolveCHRConstraint(unresolved.name);
            if (constraint != null) {
                this.relation = constraint;
                this.passive = false;
            } else {
                SCLRelation sclRelation = context.resolveRelation(unresolved.location, unresolved.name);
                if (sclRelation != null) {
                    this.relation = new ExternalCHRRelation(sclRelation);
                } else {
                    if (unresolved.name.contains(".")) {
                        context.getErrorLog().log(unresolved.location, "Couldn't resolve relation " + unresolved.name + ".");
                        return;
                    }
                    if (this.parameters == null) {
                        context.getErrorLog().log(this.location, "Relation must be declared if record syntax is used.");
                        return;
                    }
                    Type[] parameterTypes = new Type[this.parameters.length];
                    int i = 0;
                    while (i < parameterTypes.length) {
                        parameterTypes[i] = Types.metaVar(Kinds.STAR);
                        ++i;
                    }
                    constraint = new CHRConstraint(this.location, unresolved.name, parameterTypes);
                    constraint.implicitlyDeclared = true;
                    context.newCHRConstraint(constraint.name, constraint);
                    this.relation = constraint;
                    this.passive = false;
                }
            }
        }
        if (this.parameters == null && this.fields != null) {
            String[] fieldNames = this.relation.getFieldNames();
            if (fieldNames == null) {
                context.getErrorLog().log(this.location, "Relation " + String.valueOf(this.relation) + " does not define field names.");
                return;
            }
            this.parameters = ERecord.translateFieldsToFunctionParameters(context, this.fields, fieldNames, true);
            if (this.parameters == null) {
                return;
            }
            int i = 0;
            while (i < this.parameters.length) {
                Expression parameter = this.parameters[i];
                if (parameter == null) {
                    TranslationContext.ExistentialFrame frame = context.getCurrentExistentialFrame();
                    if (frame == null || frame.disallowNewExistentials) {
                        context.getErrorLog().log(this.location, "Field " + fieldNames[i] + " not defined.");
                    } else {
                        this.parameters[i] = frame.createBlank(this.location);
                    }
                } else {
                    this.parameters[i] = this.parameters[i].resolve(context);
                }
                ++i;
            }
            this.fields = null;
        }
    }

    public void checkType(TypingContext context) {
        if (this.relation == SpecialCHRRelation.EXECUTE) {
            if (this.parameters.length != 1) {
                throw new InternalCompilerError("Wrong number of parameters for EXECUTE constraint.");
            }
            this.parameters[0] = this.parameters[0].checkIgnoredType(context);
            this.typeConstraintEvidenceParameters = Expression.EMPTY_ARRAY;
        } else if (this.relation == SpecialCHRRelation.ASSIGN) {
            this.parameters[1] = this.parameters[1].inferType(context);
            this.parameters[0] = this.parameters[0].checkTypeAsPattern(context, this.parameters[1].getType());
            this.typeConstraintEvidenceParameters = Expression.EMPTY_ARRAY;
        } else {
            TVar[] typeVariables = this.relation.getTypeVariables();
            this.typeParameters = typeVariables.length == 0 ? Type.EMPTY_ARRAY : new Type[typeVariables.length];
            int i = 0;
            while (i < typeVariables.length) {
                this.typeParameters[i] = Types.metaVar(typeVariables[i].getKind());
                ++i;
            }
            Type[] parameterTypes = Types.replace(this.relation.getParameterTypes(), typeVariables, this.typeParameters);
            if (parameterTypes.length != this.parameters.length) {
                context.getErrorLog().log(this.location, "Constraint is applied with wrong number of parameters");
            } else {
                int i2 = 0;
                while (i2 < this.parameters.length) {
                    this.parameters[i2] = this.parameters[i2].checkType(context, parameterTypes[i2]);
                    ++i2;
                }
            }
            this.typeConstraintEvidenceParameters = context.addConstraints(Types.replace(this.relation.getTypeConstraints(), typeVariables, this.typeParameters));
        }
    }

    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        Expression parameter;
        Expression[] expressionArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            parameter = expressionArray[n2];
            parameter.collectVars(allVars, vars);
            ++n2;
        }
        if (this.typeConstraintEvidenceParameters != null) {
            expressionArray = this.typeConstraintEvidenceParameters;
            n = this.typeConstraintEvidenceParameters.length;
            n2 = 0;
            while (n2 < n) {
                parameter = expressionArray[n2];
                parameter.collectVars(allVars, vars);
                ++n2;
            }
        }
    }

    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            Expression[] expressionArray = this.parameters;
            int n = this.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Expression parameter = expressionArray[n2];
                parameter.setLocationDeep(loc);
                ++n2;
            }
        }
    }

    public void simplify(SimplificationContext context) {
        int i = 0;
        while (i < this.parameters.length) {
            this.parameters[i] = this.parameters[i].simplify(context);
            ++i;
        }
        if (this.typeConstraintEvidenceParameters != null) {
            i = 0;
            while (i < this.typeConstraintEvidenceParameters.length) {
                this.typeConstraintEvidenceParameters[i] = this.typeConstraintEvidenceParameters[i].simplify(context);
                ++i;
            }
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        ExpressionToStringVisitor visitor = new ExpressionToStringVisitor(b);
        visitor.visit(this);
        return b.toString();
    }

    public CHRLiteral replace(ReplaceContext context) {
        CHRLiteral copy = new CHRLiteral(this.location, this.relation, context.replace(this.parameters), this.killAfterMatch, this.negated);
        int i = 0;
        while (i < this.parameters.length) {
            copy.parameters[i] = copy.parameters[i].replace(context);
            ++i;
        }
        copy.passive = this.passive;
        copy.typeConstraintEvidenceParameters = context.replace(this.typeConstraintEvidenceParameters);
        copy.typeParameters = context.replace(this.typeParameters);
        copy.fields = context.replace(this.fields);
        return copy;
    }
}

