/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.constants;

import org.cojen.classfile.TypeDesc;
import org.objectweb.asm.Label;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.types.Types;

public class FloatConstant
extends Constant {
    float value;

    public FloatConstant(float value) {
        super(Types.FLOAT);
        this.value = value;
    }

    @Override
    public void push(MethodBuilder mb) {
        mb.loadConstant(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FloatConstant other = (FloatConstant)obj;
        return Float.floatToIntBits(this.value) == Float.floatToIntBits(other.value);
    }

    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success, Label failure) {
        mb.push(parameter, Types.FLOAT);
        mb.loadConstant(this.value);
        mb.ifComparisonBranch(failure, "!=", TypeDesc.FLOAT);
        mb.jump(success);
    }

    @Override
    public int constructorTag() {
        return 0;
    }

    @Override
    public Object realizeValue(TransientClassBuilder classBuilder) {
        return Float.valueOf(this.value);
    }
}

