package org.simantics.scl.compiler.types.util;

import gnu.trove.map.hash.THashMap;

public class TypeUnparsingContext {
    
    THashMap<Object, String> names;
    int nameId;
    public boolean showSkeletons;
    
    public TypeUnparsingContext() {
        this.names = new THashMap<Object, String>();
        this.nameId = 0;
    }
    
    public TypeUnparsingContext(TypeUnparsingContext parent) {
        this.names = new THashMap<Object, String>(parent.names);
        this.nameId = parent.nameId;
    }

    public String getName(Object var) {
        String name = names.get(var);
        if(name == null) {
            name = idToName(nameId++);
            names.put(var, name);
        }
        return name;
    }

    private static final int alphabetCount = 'z'-'a'+1;
    
    private static String idToName(int id) {
        String name = Character.toString((char)('a' + id % alphabetCount));
        id /= alphabetCount;
        if(id > 0)
            name = idToName(id-1) + name;
        return name;
    }

}
