package org.simantics.scl.compiler.internal.parsing.declarations;


public class DDocumentationAst extends DeclarationAst {
    public final String documentation;
    
    public DDocumentationAst(String documentation) {
        this.documentation = cleanUp(documentation);
    }

    @Override
    public void toString(int indentation, StringBuilder b) {
        for(int i=0;i<indentation;++i) b.append("    ");
        b.append("\"\"\"\n");
        b.append(documentation);
        b.append("\"\"\"\n");
        
    }
    
    private static String cleanUp(String documentation) {
        // Remove empty lines
        int end = documentation.length();
        while(end > 0) {
            char c = documentation.charAt(end-1);
            if(c != ' ' && c != '\n')
                break;
            --end;
        }
        
        int begin = 0;
        for(int i=0;i<end;++i) {
            char c = documentation.charAt(i);
            if(c == '\n')
                begin = i+1;
            else if(c != ' ')
                break;
        }
            
        // Calculate common indentation
        int lineStart = begin;
        int commonIndentation = Integer.MAX_VALUE;
        for(int i=begin;i<end;++i) {
            char c = documentation.charAt(i);
            if(c == '\n') {
                lineStart = i+1;
            }
            else if(lineStart >= 0 && c != ' ') {
                int indentation = i - lineStart;
                commonIndentation = Math.min(commonIndentation, indentation);
                if(commonIndentation == 0) {
                    if(begin == 0 && end == documentation.length())
                        return documentation;
                    else
                        return documentation.substring(begin, end);
                }
                lineStart = -1;
            }
        }
        
        // Remove common indentation
        StringBuilder result = new StringBuilder();
        int charsToSkip = commonIndentation;
        for(int i=begin;i<end;++i) {
            char c = documentation.charAt(i);
            if(c == '\n') {
                result.append(c);
                charsToSkip = commonIndentation;
                continue;
            }
            if(charsToSkip > 0)
                --charsToSkip;
            else
                result.append(c);
        }
        return result.toString();
    }
}
