package org.simantics.scl.compiler.environment;

import java.util.Collection;
import java.util.List;

import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeClassInstance;
import org.simantics.scl.compiler.elaboration.modules.TypeDescriptor;
import org.simantics.scl.compiler.elaboration.relations.SCLEntityType;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.elaboration.rules.TransformationRule;
import org.simantics.scl.compiler.internal.codegen.effects.EffectConstructor;
import org.simantics.scl.compiler.types.TCon;

public interface Environment extends EnvironmentalContext {
    Namespace getLocalNamespace();
    
    SCLValue getValue(Name name);
    List<Constant> getFieldAccessors(String name);
    SCLRelation getRelation(Name name);
    SCLEntityType getEntityType(Name name);
    TypeDescriptor getTypeDescriptor(TCon type);
    EffectConstructor getEffectConstructor(TCon type);
    TypeClass getTypeClass(TCon type);
    Collection<TypeClassInstance> getInstances(TCon typeClass);
    void collectRules(Collection<TransformationRule> rules);
}
