package org.simantics.scl.compiler.elaboration.expressions.list;

import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.internal.parsing.Symbol;

public abstract class ListQualifier extends Symbol {

    public abstract void checkType(TypingContext context);
    /**
     * Called in simplification.
     */
    public abstract CompiledQualifier compile(SimplificationContext context);
    public abstract void resolve(TranslationContext context);
    public abstract void setLocationDeep(long loc);
    public abstract void accept(ListQualifierVisitor visitor);
    public abstract ListQualifier accept(ListQualifierTransformer transformer);
    
}
