package org.simantics.scl.compiler.elaboration.expressions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.interpreted.IConstant;
import org.simantics.scl.compiler.internal.interpreted.IExpression;
import org.simantics.scl.compiler.top.ExpressionInterpretationContext;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

public class ELiteral extends Expression {
    Constant value;
    
    public ELiteral(Constant value) {
        this.value = value;
        setType(value.getType());
    }

    public ELiteral(long loc, Constant value) {
        super(loc);
        this.value = value;
    }

    public Constant getValue() {
        return value;
    }
    
    @Override
    public Set<Variable> getFreeVariables() {
        return Collections.emptySet();
    }

    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        b.append(value);
    }

    @Override
    protected void updateType() throws MatchException {
        setType(value.getType());	    
    }

    @Override
    public IVal toVal(CompilationContext context, CodeWriter w) {
        return value;
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        return this;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        return this;
    }
    
    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        return this;
    }
    
    @Override
    public void getParameters(TranslationContext translationContext,
            ArrayList<Expression> parameters) {
    }

    @Override
    public Expression replace(ReplaceContext context) {
        return new ELiteral(value);
    }
    
    @Override
    public IExpression toIExpression(ExpressionInterpretationContext target) {
        return new IConstant(value.realizeValue(target.localClassBuilder));
    }
    
    @Override
    public Expression inferType(TypingContext context) {
        return this;
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION)
            location = loc;
    }
    
    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
    
    @Override
    public boolean isPattern(int arity) {
        return value.constructorTag() >= 0 && value.getArity() == arity;
    }
    
    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public boolean equalsExpression(Expression expression) {
        if(expression.getClass() != getClass())
            return false;
        ELiteral other = (ELiteral)expression;
        return value.equals(other.value);
    }

    @Override
    public boolean isConstructorApplication() {
        return true;
    }
}
