package org.simantics.scl.compiler.constants;

import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.internal.codegen.utils.LocalVariable;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.types.Type;

public class LocalVariableConstant extends Constant {

    public LocalVariable var;
    
    public LocalVariableConstant(Type type, LocalVariable var) {
        super(type);
        this.var = var;
    }
    
    @Override
    public void push(MethodBuilder mb) {
        mb.loadLocal(var);
        if(var.getType() == TypeDesc.OBJECT)
            mb.unbox(type);
    }

    @Override
    public Object realizeValue(TransientClassBuilder classBuilder) {
        throw new UnsupportedOperationException();
    }

}
