package org.simantics.scl.compiler.constants;

import org.objectweb.asm.Label;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class JavaComparisonToZeroOperation extends FunctionValue implements ComparisonFunction {
    public static final JavaComparisonToZeroOperation IEQUAL = new JavaComparisonToZeroOperation("==");
    public static final JavaComparisonToZeroOperation INOT_EQUAL = new JavaComparisonToZeroOperation("!=");
    public static final JavaComparisonToZeroOperation ILESS = new JavaComparisonToZeroOperation("<");
    public static final JavaComparisonToZeroOperation ILESS_OR_EQUAL = new JavaComparisonToZeroOperation("<=");
    public static final JavaComparisonToZeroOperation IGREATER = new JavaComparisonToZeroOperation(">");
    public static final JavaComparisonToZeroOperation IGREATER_OR_EQUAL = new JavaComparisonToZeroOperation(">=");
    
    String op;
    
    public JavaComparisonToZeroOperation(String op) {
        super(TVar.EMPTY_ARRAY, Types.NO_EFFECTS, Types.BOOLEAN, Types.INTEGER);
        this.op = op;
    }

    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        Label thenBranch = mb.createLabel();
        Label joinPoint = mb.createLabel();
        
        mb.push(parameters[0], Types.INTEGER);        
        mb.ifZeroComparisonBranch(thenBranch, op);
        
        mb.loadConstant(false);
        mb.branch(joinPoint);
        
        mb.setLocation(thenBranch);
        mb.loadConstant(true);
        mb.setLocation(joinPoint);
        
        return getReturnType();
    }
    
    @Override
    public void generateCondition(MethodBuilder mb, Val[] parameters, Cont then_, Cont else_) {
        mb.push(parameters[0], Types.INTEGER);
        mb.ifZeroComparisonBranch(mb.getLabel(then_), op);
        mb.jump(else_);
        mb.ensureExists(then_);
    }
    
    @Override
    public String toString() {
        return op;
    }

}
