package org.simantics.scl.commands.internal.serialization;

import org.simantics.db.Resource;
import org.simantics.scl.commands.internal.StringConverterFactory;
import org.simantics.scl.compiler.errors.CompilationErrorFormatter;
import org.simantics.scl.compiler.module.repository.ImportFailureException;
import org.simantics.scl.compiler.top.SCLExpressionCompilationException;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.function.Function2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandSerializerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandSerializerFactory.class);
    @SuppressWarnings("unchecked")
    public static CommandSerializer create(String name, Type[] parameterTypes) {
        Function2<Resource,Object,String>[] stringConverters = new Function[parameterTypes.length];
        for(int i=0;i<parameterTypes.length;++i) {
            try {
                stringConverters[i] = StringConverterFactory.stringConverterFor(parameterTypes[i]);
            } catch(SCLExpressionCompilationException e) {
                LOGGER.error("Failed to create a string converter for type " + parameterTypes[i] + ".");
                LOGGER.error(CompilationErrorFormatter.toString(e.getErrors()), e);
                return new ErrorSerializer(name);
            } catch (ImportFailureException e) {
                LOGGER.error("Failed to create a string converter for type " + parameterTypes[i] + ".");
                LOGGER.error("Didn't find Simantics/GShow/gshow.", e);
                return new ErrorSerializer(name);
            }
        }
        return new CommandSerializerImpl(name, stringConverters);
    }
}
