/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.utils;

import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Arrays;

public final class TextUtil {
    public static String[] wordWrap(String text, FontMetrics metrics, int maxLineWidth) {
        ArrayList<Object> result = new ArrayList<Object>();
        int[] whitespacePos = new int[8];
        int whitespaceTop = 0;
        int pos = 0;
        int length = text.length();
        int cumulatedLineWidth = 0;
        int dotWidth = metrics.charWidth('.');
        int dot3Width = 3 * dotWidth;
        boolean nonWhitespaceFound = false;
        while (pos < length) {
            char c = text.charAt(pos);
            int cWidth = metrics.charWidth(c);
            if (Character.isWhitespace(c)) {
                if (nonWhitespaceFound) {
                    if (whitespacePos.length <= whitespaceTop) {
                        whitespacePos = Arrays.copyOf(whitespacePos, whitespacePos.length * 2);
                    }
                    whitespacePos[whitespaceTop++] = pos;
                }
            } else {
                nonWhitespaceFound = true;
            }
            if (cumulatedLineWidth + cWidth > maxLineWidth) {
                int nextLineStartPos = -1;
                if (whitespaceTop > 0) {
                    int cutPos = whitespacePos[--whitespaceTop];
                    result.add(text.substring(0, cutPos));
                    nextLineStartPos = cutPos + 1;
                } else {
                    int rollbackWidth = cumulatedLineWidth + dot3Width;
                    int rollbackPos = pos;
                    while (rollbackPos > 0 && rollbackWidth > maxLineWidth) {
                        rollbackWidth -= metrics.charWidth(text.charAt(--rollbackPos));
                    }
                    if (rollbackPos == 0) {
                        result.add(text);
                        break;
                    }
                    result.add(text.substring(0, rollbackPos) + "...");
                    int nextWhitespacePos = pos;
                    while (nextWhitespacePos < length && !Character.isWhitespace(text.charAt(nextWhitespacePos))) {
                        ++nextWhitespacePos;
                    }
                    nextLineStartPos = nextWhitespacePos < length ? nextWhitespacePos + 1 : nextWhitespacePos;
                }
                text = text.substring(nextLineStartPos);
                length = text.length();
                pos = 0;
                cumulatedLineWidth = 0;
                nonWhitespaceFound = false;
                whitespaceTop = 0;
                continue;
            }
            cumulatedLineWidth += cWidth;
            ++pos;
        }
        if (text.length() > 0) {
            result.add(text);
        }
        return result.toArray(new String[result.size()]);
    }
}

