/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.utils;

import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class DPIUtil {
    private static boolean initialized = false;
    private static boolean hasZoom;
    private static float upscaleFactorF;
    private static double upscaleFactorD;
    private static float downscaleFactorF;
    private static double downscaleFactorD;

    private static void initialize() {
        if (initialized) {
            return;
        }
        double dpi = !GraphicsEnvironment.isHeadless() ? (double)Toolkit.getDefaultToolkit().getScreenResolution() : 96.0;
        double baseDpi = 96.0;
        int zoom = (int)Math.round(100.0 * dpi / baseDpi);
        hasZoom = zoom != 100;
        upscaleFactorD = dpi / baseDpi;
        upscaleFactorF = (float)upscaleFactorD;
        downscaleFactorD = baseDpi / dpi;
        downscaleFactorF = (float)downscaleFactorD;
        initialized = true;
    }

    private static Rectangle scale(float s, Rectangle r, Rectangle target) {
        if (s == 1.0f) {
            if (r == target) {
                return r;
            }
            if (target == null) {
                return new Rectangle(r.x, r.y, r.width, r.height);
            }
            target.x = r.x;
            target.y = r.y;
            target.width = r.width;
            target.height = r.height;
            return target;
        }
        if (target == null) {
            return new Rectangle(Math.round((float)r.x * s), Math.round((float)r.y * s), Math.round((float)r.width * s), Math.round((float)r.height * s));
        }
        target.x = Math.round((float)r.x * s);
        target.y = Math.round((float)r.y * s);
        target.width = Math.round((float)r.width * s);
        target.height = Math.round((float)r.height * s);
        return target;
    }

    private static Rectangle2D scale(double s, Rectangle2D r, Rectangle2D target) {
        if (s == 1.0) {
            if (r == target) {
                return r;
            }
            if (target == null) {
                return (Rectangle2D)r.clone();
            }
            target.setFrame(r);
            return target;
        }
        if (target == null) {
            target = (Rectangle2D)r.clone();
        }
        target.setFrame(r.getX() * s, r.getY() * s, r.getWidth() * s, r.getHeight() * s);
        return target;
    }

    private static double downscale0(double x) {
        return hasZoom ? x * downscaleFactorD : x;
    }

    private static int downscaleToInteger0(double x) {
        return (int)(hasZoom ? (double)Math.round(x * downscaleFactorD) : x);
    }

    private static int downscale0(int x) {
        return hasZoom ? (int)Math.round((double)x * downscaleFactorD) : x;
    }

    private static double upscale0(double x) {
        return hasZoom ? x * upscaleFactorD : x;
    }

    private static int upscaleToInteger0(double x) {
        return (int)(hasZoom ? (double)Math.round(x * upscaleFactorD) : x);
    }

    private static int upscale0(int x) {
        return hasZoom ? (int)Math.round((double)x * upscaleFactorD) : x;
    }

    public static double downscale(double x) {
        DPIUtil.initialize();
        return DPIUtil.downscale0(x);
    }

    public static int downscale(int x) {
        DPIUtil.initialize();
        return DPIUtil.downscale0(x);
    }

    public static Point2D downscale(double x, double y) {
        DPIUtil.initialize();
        if (!hasZoom) {
            return new Point2D.Double(x, y);
        }
        double s = downscaleFactorD;
        return new Point2D.Double(x * s, y * s);
    }

    public static Point downscale(int x, int y) {
        DPIUtil.initialize();
        return new Point(DPIUtil.downscale0(x), DPIUtil.downscale0(y));
    }

    public static Point2D downscale(Point2D p) {
        return DPIUtil.downscale(p.getX(), p.getY());
    }

    public static Point downscaleToInteger(Point2D p) {
        DPIUtil.initialize();
        return new Point(DPIUtil.downscaleToInteger0(p.getX()), DPIUtil.downscaleToInteger0(p.getY()));
    }

    public static Rectangle2D downscale(Rectangle2D r, Rectangle2D target) {
        DPIUtil.initialize();
        return DPIUtil.scale(downscaleFactorD, r, target);
    }

    public static Rectangle2D downscale(Rectangle2D r) {
        return DPIUtil.downscale(r, null);
    }

    public static Rectangle downscale(Rectangle r, Rectangle target) {
        DPIUtil.initialize();
        return DPIUtil.scale(downscaleFactorF, r, target);
    }

    public static Rectangle downscale(Rectangle r) {
        return DPIUtil.downscale(r, null);
    }

    public static Rectangle downscaleToInteger(Rectangle2D r) {
        DPIUtil.initialize();
        return new Rectangle(DPIUtil.downscaleToInteger0(r.getMinX()), DPIUtil.downscaleToInteger0(r.getMinY()), DPIUtil.downscaleToInteger0(r.getWidth()), DPIUtil.downscaleToInteger0(r.getHeight()));
    }

    public static double upscale(double x) {
        DPIUtil.initialize();
        return DPIUtil.upscale0(x);
    }

    public static int upscale(int x) {
        DPIUtil.initialize();
        return DPIUtil.upscale0(x);
    }

    public static Point2D upscale(double x, double y) {
        DPIUtil.initialize();
        if (!hasZoom) {
            return new Point2D.Double(x, y);
        }
        double s = upscaleFactorD;
        return new Point2D.Double(x * s, y * s);
    }

    public static Point upscale(int x, int y) {
        DPIUtil.initialize();
        return new Point(DPIUtil.upscale0(x), DPIUtil.upscale0(y));
    }

    public static Point2D upscale(Point2D p) {
        DPIUtil.initialize();
        return hasZoom && p != null ? DPIUtil.upscale(p.getX(), p.getY()) : p;
    }

    public static Point upscaleToInteger(Point2D p) {
        DPIUtil.initialize();
        return new Point(DPIUtil.upscaleToInteger0(p.getX()), DPIUtil.upscaleToInteger0(p.getY()));
    }

    public static Point upscale(Point p) {
        DPIUtil.initialize();
        return hasZoom && p != null ? DPIUtil.upscale(p.x, p.y) : p;
    }

    public static Rectangle2D upscale(Rectangle2D r, Rectangle2D target) {
        DPIUtil.initialize();
        return DPIUtil.scale(upscaleFactorD, r, target);
    }

    public static Rectangle upscale(Rectangle r, Rectangle target) {
        DPIUtil.initialize();
        return DPIUtil.scale(upscaleFactorF, r, target);
    }

    public static Rectangle2D upscale(Rectangle2D r) {
        return DPIUtil.upscale(r, null);
    }

    public static Rectangle upscale(Rectangle r) {
        return DPIUtil.upscale(r, null);
    }

    public static Rectangle upscaleToInteger(Rectangle2D r) {
        return new Rectangle(DPIUtil.upscaleToInteger0(r.getMinX()), DPIUtil.upscaleToInteger0(r.getMinY()), DPIUtil.upscaleToInteger0(r.getWidth()), DPIUtil.upscaleToInteger0(r.getHeight()));
    }
}

