/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes.provisional;

import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.simantics.scenegraph.g2d.G2DNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GraphPropertyNode
extends G2DNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphPropertyNode.class);
    private static final long serialVersionUID = 245761992671850588L;
    private static Map<Class<? extends GraphPropertyNode>, Map<String, Field>> fieldCache = new ConcurrentHashMap<Class<? extends GraphPropertyNode>, Map<String, Field>>();
    protected final transient Map<String, Field> fields = GraphPropertyNode.getFields(this.getClass());
    private PropertyChangeListener fieldListener = null;

    protected GraphPropertyNode() {
    }

    @Override
    public void init() {
        super.init();
        this.addEventHandler(this);
    }

    @Override
    public void cleanup() {
        this.removeEventHandler(this);
        super.cleanup();
    }

    public void setFieldListener(PropertyChangeListener listener) {
        this.fieldListener = listener;
    }

    public void propertyChange(String field, Object value) {
    }

    public void setProperty(String field, Object value) {
        Field f = this.fields.get(field);
        if (f == null) {
            LOGGER.warn("GraphPropertyNode tried to set undefined property '" + field + "'");
            return;
        }
        try {
            f.set(this, value);
            this.propertyChange(field, value);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void commitProperty(String field, Object value) {
        if (this.fieldListener != null) {
            this.fieldListener.propertyChange(new PropertyChangeEvent(this, field, null, value));
        }
    }

    public boolean hitTest(double x, double y, double tolerance) {
        return false;
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return null;
    }

    private static Map<String, Field> getFields(Class<? extends GraphPropertyNode> clazz) {
        Map<String, Field> fields = fieldCache.get(clazz);
        if (fields != null) {
            return fields;
        }
        fields = GraphPropertyNode.calculateFields(clazz);
        fieldCache.put(clazz, fields);
        return fields;
    }

    private static Map<String, Field> calculateFields(Class<? extends GraphPropertyNode> clazz) {
        HashMap<String, Field> result = new HashMap<String, Field>();
        Class<? extends GraphPropertyNode> cls = clazz;
        while (cls != null && !GraphPropertyNode.class.equals(cls)) {
            Field[] fieldArray = cls.getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                int mod = f.getModifiers();
                if (!(Modifier.isStatic(mod) || Modifier.isTransient(mod) || Modifier.isFinal(mod) || result.containsKey(f.getName()))) {
                    result.put(f.getName(), f);
                }
                ++n2;
            }
            cls = clazz.getSuperclass();
        }
        return result;
    }
}

