/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.ExportableWidget;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;

@ExportableWidget.OutputWidget(value={"text"})
public class TextNode
extends G2DNode {
    private static final long serialVersionUID = 8508750881358776559L;
    protected Rectangle2D bounds = null;
    protected String text = null;
    protected Font font = null;
    protected Color color = Color.BLACK;

    @INode.SyncField(value={"bounds"})
    public void setBounds(Rectangle2D bounds) {
        this.bounds = bounds;
    }

    @INode.SyncField(value={"font"})
    public void setFont(Font font) {
        this.font = font;
    }

    @INode.SyncField(value={"text"})
    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    @INode.SyncField(value={"color"})
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public void render(Graphics2D g) {
        if (this.text == null || this.bounds == null || this.font == null || this.color == null) {
            return;
        }
        g.setFont(this.font);
        g.setColor(this.color);
        FontMetrics fm = g.getFontMetrics(this.font);
        Rectangle2D rect = fm.getStringBounds(this.text, g);
        float x = (float)((this.bounds.getWidth() - rect.getWidth()) / 2.0 + this.bounds.getMinX());
        float y = (float)((this.bounds.getHeight() - rect.getHeight()) / 2.0 + this.bounds.getMinY());
        AffineTransform at = g.getTransform();
        g.transform(this.getTransform());
        g.drawString(this.text, x, (float)((double)y + rect.getHeight()));
        g.setTransform(at);
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return this.bounds;
    }

    @Override
    public Rectangle2D getBounds() {
        return null;
    }
}

