/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;

public class BackgroundNode
extends G2DNode {
    private static final long serialVersionUID = 2805713128639560702L;
    protected Color color = null;
    protected Paint paint = null;
    protected Rectangle2D bounds = null;

    @INode.SyncField(value={"color"})
    public void setColor(Color color) {
        this.color = color;
    }

    @INode.SyncField(value={"paint"})
    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    @INode.SyncField(value={"bounds"})
    public void setBounds(Rectangle2D bounds) {
        this.bounds = bounds;
    }

    @Override
    public void render(Graphics2D g) {
        Rectangle2D drawBounds = this.bounds;
        if (drawBounds == null) {
            if (g.getClipBounds() != null) {
                drawBounds = (Rectangle2D)g.getClipBounds().clone();
            } else {
                return;
            }
        }
        if (this.color != null) {
            g.setColor(this.color);
            g.fill(drawBounds);
        } else if (this.paint != null) {
            g.setPaint(this.paint);
            g.fill(drawBounds);
        }
    }

    @Override
    public String toString() {
        return super.toString() + " [color=" + String.valueOf(this.color) + "]";
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return this.bounds;
    }
}

