/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph;

import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.NodeException;

public abstract class ParentNode<T extends INode>
extends Node {
    private static final long serialVersionUID = 8519410262849626534L;
    public static final String EXISTING = "#EXISTING#";
    public static final String UNLINK = "#UNLINK#";
    public static final String NULL = "#NULL#";
    protected static final ParentNode<?> DISPOSED = new ParentNode<INode>(){
        private static final long serialVersionUID = 6155494069158034123L;

        @Override
        public void asyncRemoveNode(INode node) {
            throw new Error();
        }
    };
    private static final Map<String, INode> DISPOSED_CHILDREN = Collections.emptyMap();
    private static final TLongObjectMap<String> DISPOSED_CHILDREN_ID_MAP = new ImmutableIdMap();
    protected transient Map<String, INode> children = this.createChildMap();
    private transient TLongObjectMap<String> childrenIdMap = new TLongObjectHashMap();
    protected volatile transient ParentNode<?> rootNodeCache;

    protected Map<String, INode> createChildMap() {
        return this.createChildMap(1);
    }

    protected Map<String, INode> createChildMap(int initialCapacity) {
        return new HashMap<String, INode>(initialCapacity);
    }

    public final <TC> TC addNode(Class<TC> a) {
        return this.addNode(UUID.randomUUID().toString(), a);
    }

    public <TC extends INode> TC addNode(String id, TC child) {
        return this.addNodeInternal(id, child, true, true);
    }

    private <TC extends INode> TC addNodeInternal(String id, TC child, boolean init, boolean addToChildren) {
        child.setParent(this);
        if (addToChildren) {
            this.children.put(id, child);
        }
        this.childrenIdMap.put(child.getId(), (Object)id);
        if (init) {
            child.init();
        }
        this.childrenChanged();
        return child;
    }

    public <TC extends INode> TC attachNode(String id, TC child) {
        return this.addNodeInternal(id, child, false, true);
    }

    public <TC extends INode> TC detachNode(String id) {
        INode child = this.children.remove(id);
        if (child == null) {
            return null;
        }
        this.childrenIdMap.remove(child.getId());
        child.setParent(null);
        this.childrenChanged();
        return (TC)child;
    }

    public <TC> TC addNode(String id, Class<TC> a) {
        return this.addNodeInternal0(id, a, true);
    }

    private <TC> TC addNodeInternal0(String id, Class<TC> a, boolean addToChildren) {
        if (!Node.class.isAssignableFrom(a)) {
            throw new IllegalArgumentException(String.valueOf(a) + " is not extended from org.simantics.scenegraph.Node");
        }
        Node child = null;
        try {
            child = (Node)a.newInstance();
        }
        catch (InstantiationException e) {
            throw new NodeException("Node " + Node.getSimpleClassName(a) + " instantiation failed, see exception for details.", e);
        }
        catch (IllegalAccessException e) {
            throw new NodeException("Node " + Node.getSimpleClassName(a) + " instantiation failed, see exception for details.", e);
        }
        return (TC)this.addNodeInternal(id, child, true, addToChildren);
    }

    public final <TC extends INode> TC getOrAttachNode(String id, TC a) {
        return (TC)this.children.computeIfAbsent(id, key -> this.addNodeInternal(id, a, false, false));
    }

    public final <TC> TC getOrCreateNode(String id, Class<TC> a) {
        return (TC)this.children.computeIfAbsent(id, key -> (INode)this.addNodeInternal0(id, a, false));
    }

    public final void removeNode(String id) {
        INode child = this.children.remove(id);
        if (child != null) {
            this.removeNodeInternal(child, true);
        }
    }

    public final void removeNode(INode child) {
        String key = (String)this.childrenIdMap.get(child.getId());
        this.removeNode(key);
    }

    public final void removeNodes() {
        boolean changed = this.children.size() > 0;
        this.children.forEach((id, child) -> this.removeNodeInternal((INode)child, false));
        this.children.clear();
        this.childrenIdMap.clear();
        if (changed) {
            this.childrenChanged();
        }
    }

    private void removeNodeInternal(INode child, boolean triggerChildrenChanged) {
        if (child != null) {
            if (child instanceof ParentNode) {
                ((ParentNode)child).removeNodes();
            }
            child.cleanup();
            child.setParent(null);
            if (triggerChildrenChanged) {
                this.childrenChanged();
            }
            this.triggerPropertyChangeEvent(child);
        }
    }

    protected void childrenChanged() {
    }

    public abstract void asyncRemoveNode(INode var1);

    public T getNode(String id) {
        return (T)this.children.get(id);
    }

    public Collection<String> getNodeIds() {
        return this.children.keySet();
    }

    public Collection<T> getNodes() {
        return this.children.isEmpty() ? Collections.emptyList() : this.children.values();
    }

    public int getNodeCount() {
        return this.children.size();
    }

    public void setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListener = propertyChangeListener;
        this.children.forEach((id, child) -> {
            if (child instanceof ParentNode) {
                ((ParentNode)child).setPropertyChangeListener(propertyChangeListener);
            } else {
                ((Node)child).propertyChangeListener = propertyChangeListener;
            }
        });
    }

    @Override
    public void cleanup() {
        this.retractMapping();
        if (this.children != DISPOSED_CHILDREN) {
            this.children.forEach((id, child) -> {
                child.cleanup();
                child.setParent(null);
            });
            this.children.clear();
            this.childrenIdMap.clear();
            this.children = DISPOSED_CHILDREN;
            this.childrenIdMap = DISPOSED_CHILDREN_ID_MAP;
            this.childrenChanged();
            this.rootNodeCache = DISPOSED;
        }
    }

    @Override
    public void delete() {
        if (this.parent == null) {
            return;
        }
        this.parent.appendChildren(this.children);
        this.children.clear();
        this.childrenIdMap.clear();
        this.parent.unlinkChild(this);
        this.cleanup();
    }

    protected void appendChildren(Map<String, INode> children) {
        children.forEach((key, value) -> this.appendChildInternal((String)key, (INode)value));
    }

    protected void appendChild(String id, INode child) {
        this.appendChildInternal(id, child);
    }

    private void appendChildInternal(String id, INode child) {
        this.children.put(id, child);
        this.childrenIdMap.put(child.getId(), (Object)id);
        child.setParent(this);
        this.triggerPropertyChangeEvent(child);
    }

    protected void unlinkChild(INode child) {
        String id = (String)this.childrenIdMap.remove(child.getId());
        if (id != null) {
            this.children.remove(id);
            this.childrenChanged();
            this.triggerPropertyChangeEvent(child);
        }
    }

    private void triggerPropertyChangeEvent(INode child) {
        if (this.propertyChangeListener != null && this.location.equals((Object)INode.Location.LOCAL)) {
            this.propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "children[" + child.getId() + "]", child.getClass(), UNLINK));
        }
    }

    @Override
    public String toString() {
        return super.toString() + " [#child=" + this.children.size() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParentNode<?> getRootNode() {
        ParentNode<?> result = this.rootNodeCache;
        if (result == DISPOSED) {
            return null;
        }
        if (result == null) {
            ParentNode parentNode = this;
            synchronized (parentNode) {
                result = this.rootNodeCache;
                if (result == null && this.parent != null) {
                    this.rootNodeCache = result = this.parent.getRootNode();
                }
            }
        }
        return result;
    }

    private static class ImmutableIdMap
    extends TLongObjectHashMap<String> {
        private static final String MSG = "immutable singleton instance";

        private ImmutableIdMap() {
        }

        public String put(long key, String value) {
            throw new UnsupportedOperationException(MSG);
        }

        public void putAll(Map<? extends Long, ? extends String> map) {
            throw new UnsupportedOperationException(MSG);
        }

        public void putAll(TLongObjectMap<? extends String> map) {
            throw new UnsupportedOperationException(MSG);
        }

        public String putIfAbsent(long key, String value) {
            throw new UnsupportedOperationException(MSG);
        }
    }
}

