/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.ui;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;
import org.simantics.scenegraph.ILookupService;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.nodes.BoundsNode;
import org.simantics.scenegraph.g2d.nodes.BranchPointNode;
import org.simantics.scenegraph.g2d.nodes.EdgeNode;
import org.simantics.scenegraph.g2d.nodes.GridNode;
import org.simantics.scenegraph.g2d.nodes.LinkNode;
import org.simantics.scenegraph.g2d.nodes.NavigationNode;
import org.simantics.scenegraph.g2d.nodes.PageBorderNode;
import org.simantics.scenegraph.g2d.nodes.RulerNode;
import org.simantics.scenegraph.g2d.nodes.SVGNode;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.g2d.nodes.TransformNode;
import org.simantics.scenegraph.ui.AttributeDialog;
import org.simantics.scenegraph.ui.NodeProxy;
import org.simantics.scenegraph.utils.NodeUtil;

public class SceneGraphViewPart
extends ViewPart {
    TreeViewer tree;
    LocalResourceManager resourceManager;
    boolean bootstrapped = false;
    IContextActivation contextActivation;
    int currentNodeCount = 0;
    boolean linkToPart;
    IWorkbenchPart lastPart;
    AttributeDialog attributeDialog;
    final ImageDescriptor ROOT = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("bullet_home.png"));
    final ImageDescriptor CANVAS_BOUNDS = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("application.png"));
    final ImageDescriptor SHAPE = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("shape_shadow.png"));
    final ImageDescriptor NAVIGATION = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("arrow_out_longer.png"));
    final ImageDescriptor SVG = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("script_code.png"));
    final ImageDescriptor TRANSFORM = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("arrow_nsew.png"));
    final ImageDescriptor ELEMENT = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("shape_handles.png"));
    final ImageDescriptor PARENT = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("share.png"));
    final ImageDescriptor GRID = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("border_all.png"));
    final ImageDescriptor RULER = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("text_ruler.png"));
    final ImageDescriptor PAGE_BORDER = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("page_white.png"));
    final ImageDescriptor EDGE = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("arrow_ew.png"));
    final ImageDescriptor BRANCH_POINT = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("bullet_black.png"));
    final ImageDescriptor LINK = ImageDescriptor.createFromURL((URL)((Object)((Object)this)).getClass().getResource("link.png"));
    NodeUtil.NodeProcedure<NodeProxy> nodeProcedure = new NodeUtil.NodeProcedure<NodeProxy>(){

        public NodeProxy execute(INode node, String id) {
            return new NodeProxy(node, id);
        }
    };
    IPartListener2 partListener = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            IWorkbenchPart part;
            if (SceneGraphViewPart.this.linkToPart && (part = partRef.getPart(false)) != null) {
                SceneGraphViewPart.this.refresh(null);
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            IWorkbenchPart part;
            if (SceneGraphViewPart.this.linkToPart && (part = partRef.getPart(false)) != null && part != SceneGraphViewPart.this.lastPart) {
                SceneGraphViewPart.this.refresh(part);
            }
        }
    };

    private Image toImage(NodeProxy proxy) {
        INode n = proxy.getNode();
        if (n == null) {
            return null;
        }
        if (n instanceof G2DSceneGraph) {
            return this.resourceManager.createImage(this.ROOT);
        }
        if (n instanceof SingleElementNode) {
            return this.resourceManager.createImage(this.ELEMENT);
        }
        if (n instanceof TransformNode) {
            return this.resourceManager.createImage(this.TRANSFORM);
        }
        if (n instanceof NavigationNode) {
            return this.resourceManager.createImage(this.NAVIGATION);
        }
        if (n instanceof BoundsNode) {
            return this.resourceManager.createImage(this.CANVAS_BOUNDS);
        }
        if (n instanceof EdgeNode) {
            return this.resourceManager.createImage(this.EDGE);
        }
        if (n instanceof BranchPointNode) {
            return this.resourceManager.createImage(this.BRANCH_POINT);
        }
        if (n instanceof ShapeNode) {
            return this.resourceManager.createImage(this.SHAPE);
        }
        if (n instanceof SVGNode) {
            return this.resourceManager.createImage(this.SVG);
        }
        if (n instanceof G2DParentNode) {
            return this.resourceManager.createImage(this.PARENT);
        }
        if (n instanceof GridNode) {
            return this.resourceManager.createImage(this.GRID);
        }
        if (n instanceof RulerNode) {
            return this.resourceManager.createImage(this.RULER);
        }
        if (n instanceof PageBorderNode) {
            return this.resourceManager.createImage(this.PAGE_BORDER);
        }
        if (n instanceof LinkNode) {
            return this.resourceManager.createImage(this.LINK);
        }
        return null;
    }

    public void createPartControl(Composite parent) {
        this.tree = new TreeViewer(parent, 65540);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.tree.getTree());
        TreeColumnLayout ad = new TreeColumnLayout();
        parent.setLayout((Layout)ad);
        this.tree.setContentProvider((IContentProvider)new ContentProvider());
        this.tree.getTree().setHeaderVisible(true);
        this.tree.setUseHashlookup(true);
        this.tree.setAutoExpandLevel(3);
        TreeViewerColumn nameColumn = new TreeViewerColumn(this.tree, 16384);
        TreeViewerColumn typeColumn = new TreeViewerColumn(this.tree, 16384);
        TreeViewerColumn idColumn = new TreeViewerColumn(this.tree, 16384);
        TreeViewerColumn lookupIdColumn = new TreeViewerColumn(this.tree, 16384);
        TreeViewerColumn zColumn = new TreeViewerColumn(this.tree, 16384);
        nameColumn.setLabelProvider((CellLabelProvider)new IdLabelProvider());
        typeColumn.setLabelProvider((CellLabelProvider)new TypeLabelProvider());
        idColumn.setLabelProvider((CellLabelProvider)new InternalIdLabelProvider());
        lookupIdColumn.setLabelProvider((CellLabelProvider)new LookupIdLabelProvider());
        zColumn.setLabelProvider((CellLabelProvider)new ZLabelProvider());
        nameColumn.getColumn().setText("Name");
        nameColumn.getColumn().setWidth(20);
        ad.setColumnData((Widget)nameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(80, 100));
        typeColumn.getColumn().setText("Type");
        typeColumn.getColumn().setWidth(20);
        ad.setColumnData((Widget)typeColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 120));
        idColumn.getColumn().setText("ID");
        idColumn.getColumn().setWidth(20);
        ad.setColumnData((Widget)idColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, 50));
        lookupIdColumn.getColumn().setText("Lookup ID");
        lookupIdColumn.getColumn().setWidth(20);
        ad.setColumnData((Widget)lookupIdColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(50, 100));
        zColumn.getColumn().setText("Z");
        zColumn.getColumn().setWidth(70);
        ad.setColumnData((Widget)zColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(10, 70));
        this.tree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SceneGraphViewPart.this.updateContentDescription();
            }
        });
        this.tree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SceneGraphViewPart.this.openAttributeDialog();
            }
        });
        this.contextActivation = ((IContextService)this.getSite().getService(IContextService.class)).activateContext("org.simantics.scenegraph.viewer");
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand("org.simantics.scenegraph.linkToActiveWorkbenchPart");
        State state = command.getState("org.simantics.scenegraph.linkToActiveWorkbenchPart.state");
        this.linkToPart = Boolean.TRUE.equals(state.getValue());
        IPartService partService = (IPartService)this.getSite().getService(IPartService.class);
        partService.addPartListener(this.partListener);
    }

    public void dispose() {
        this.closeAttributeDialog();
    }

    protected void openAttributeDialog() {
        Shell shell;
        if (this.attributeDialog != null && ((shell = this.attributeDialog.getShell()) == null || shell.isDisposed())) {
            this.attributeDialog = null;
        }
        if (this.attributeDialog == null) {
            this.attributeDialog = new AttributeDialog(this.getSite().getShell(), (ISelectionProvider)this.tree);
            this.attributeDialog.setBlockOnOpen(false);
            this.attributeDialog.open();
        }
    }

    protected void closeAttributeDialog() {
        if (this.attributeDialog != null) {
            this.attributeDialog.close();
            this.attributeDialog = null;
        }
    }

    public void setFocus() {
        this.tree.getTree().setFocus();
        if (!this.bootstrapped) {
            this.bootstrapped = true;
            this.refresh();
        }
    }

    protected void refresh() {
        IEditorPart part = null;
        try {
            IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
            if (window == null) {
                return;
            }
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                return;
            }
            part = page.getActiveEditor();
            if (part == null) {
                return;
            }
        }
        finally {
            if (part == null) {
                this.setContentDescription("No scene graph nodes available.");
            }
        }
        this.refresh((IWorkbenchPart)part);
    }

    protected boolean refresh(IWorkbenchPart part) {
        boolean foundInput = true;
        try {
            Object obj = null;
            if (part != null && (obj = part.getAdapter(INode[].class)) == null) {
                obj = part.getAdapter(INode.class);
            }
            if (obj != null) {
                TreePath[] expanded = this.tree.getExpandedTreePaths();
                this.tree.setInput(obj);
                this.tree.setExpandedTreePaths(expanded);
                this.currentNodeCount = this.countNodes(obj);
                this.updateContentDescription();
                foundInput = true;
            }
            this.lastPart = part;
            boolean bl = foundInput;
            return bl;
        }
        finally {
            if (!foundInput) {
                this.setContentDescription("No scene graph nodes available.");
            }
        }
    }

    private void updateContentDescription() {
        NodeProxy np;
        INode n;
        StringBuilder desc = new StringBuilder();
        desc.append(this.currentNodeCount + " nodes in total.");
        IStructuredSelection ss = (IStructuredSelection)this.tree.getSelection();
        Object obj = ss.getFirstElement();
        if (obj instanceof NodeProxy && (n = (np = (NodeProxy)obj).getNode()) != null) {
            int depth = NodeUtil.getDepth((INode)n);
            desc.append(" Selection ");
            desc.append("at depth ");
            desc.append(depth);
            desc.append(".");
        }
        this.setContentDescription(desc.toString());
    }

    private int countNodes(Object obj) {
        if (obj instanceof INode) {
            INode n = (INode)obj;
            return NodeUtil.countTreeNodes((INode)n);
        }
        if (obj instanceof INode[]) {
            INode[] ns = (INode[])obj;
            int result = 0;
            INode[] iNodeArray = ns;
            int n = ns.length;
            int n2 = 0;
            while (n2 < n) {
                INode n3 = iNodeArray[n2];
                result += NodeUtil.countTreeNodes((INode)n3);
                ++n2;
            }
            return result;
        }
        return 0;
    }

    void copySelectionToClipboard() {
        IStructuredSelection selection = (IStructuredSelection)this.tree.getSelection();
        Object obj = selection.getFirstElement();
        if (!(obj instanceof NodeProxy)) {
            return;
        }
        NodeProxy np = (NodeProxy)obj;
        INode n = np.getNode();
        if (n == null) {
            return;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(100000);
        PrintStream stream = new PrintStream(bytes);
        NodeUtil.printSceneGraph((PrintStream)stream, (int)0, (INode)n);
        String textData = new String(bytes.toByteArray());
        if (textData.isEmpty()) {
            return;
        }
        Clipboard clipboard = new Clipboard(this.tree.getControl().getDisplay());
        TextTransfer textTransfer = TextTransfer.getInstance();
        Transfer[] transfers = new Transfer[]{textTransfer};
        Object[] data = new Object[]{textData};
        clipboard.setContents(data, transfers);
        clipboard.dispose();
    }

    void collapseAll() {
        Object[] objectArray = this.tree.getExpandedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            this.tree.setExpandedState(obj, false);
            ++n2;
        }
    }

    void expandSelectedNode() {
        IStructuredSelection ss = (IStructuredSelection)this.tree.getSelection();
        for (Object obj : ss.toList()) {
            this.tree.expandToLevel(obj, -1);
        }
    }

    public void linkToActiveWorkbenchPart(boolean value) {
        this.linkToPart = value;
    }

    class ContentProvider
    implements ITreeContentProvider {
        ContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            NodeProxy np;
            INode n;
            if (parentElement instanceof NodeProxy && (n = (np = (NodeProxy)parentElement).getNode()) != null) {
                List children = NodeUtil.forChildren((INode)n, SceneGraphViewPart.this.nodeProcedure);
                return children.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            NodeProxy np;
            INode n;
            if (element instanceof NodeProxy && (n = (np = (NodeProxy)element).getNode()) != null) {
                return NodeUtil.hasChildren((INode)n);
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof INode[]) {
                INode[] ns = (INode[])inputElement;
                Object[] result = new NodeProxy[ns.length];
                int i = 0;
                while (i < ns.length) {
                    result[i] = new NodeProxy(ns[i], "root");
                    ++i;
                }
                return result;
            }
            if (inputElement instanceof INode) {
                INode n = (INode)inputElement;
                return new Object[]{new NodeProxy(n, "root")};
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class IdLabelProvider
    extends ColumnLabelProvider {
        IdLabelProvider() {
        }

        public void update(ViewerCell cell) {
            NodeProxy proxy = (NodeProxy)cell.getElement();
            cell.setText(proxy.getId());
            cell.setImage(SceneGraphViewPart.this.toImage(proxy));
        }
    }

    class InternalIdLabelProvider
    extends ColumnLabelProvider {
        InternalIdLabelProvider() {
        }

        public void update(ViewerCell cell) {
            NodeProxy proxy = (NodeProxy)cell.getElement();
            cell.setText(proxy.getInternalId());
        }
    }

    class LookupIdLabelProvider
    extends ColumnLabelProvider {
        LookupIdLabelProvider() {
        }

        public void update(ViewerCell cell) {
            ILookupService lut;
            NodeProxy proxy = (NodeProxy)cell.getElement();
            INode node = proxy.getNode();
            String lookupId = null;
            if (node != null && (lut = NodeUtil.tryGetLookupService((INode)node)) != null) {
                lookupId = lut.lookupId(node);
            }
            cell.setText(lookupId != null ? lookupId : "");
        }
    }

    class TypeLabelProvider
    extends ColumnLabelProvider {
        TypeLabelProvider() {
        }

        public void update(ViewerCell cell) {
            NodeProxy proxy = (NodeProxy)cell.getElement();
            cell.setText(proxy.getTypeName());
        }
    }

    class ZLabelProvider
    extends ColumnLabelProvider {
        ZLabelProvider() {
        }

        public void update(ViewerCell cell) {
            NodeProxy proxy = (NodeProxy)cell.getElement();
            INode node = proxy.getNode();
            if (node instanceof IG2DNode) {
                IG2DNode n = (IG2DNode)node;
                cell.setText(String.valueOf(n.getZIndex()));
            } else {
                cell.setText("-");
            }
        }
    }
}

