/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JToggleButton;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.swing.ComponentNode;
import org.simantics.scenegraph.utils.DummyComponent;

public class JBooleanToggleValueNode
extends ComponentNode<JToggleButton>
implements ActionListener {
    private static final long serialVersionUID = 3255791584573492072L;
    protected static final BasicStroke STROKE = new BasicStroke(1.0f);
    protected static final Rectangle2D BOUNDS = new Rectangle2D.Double(-10.0, -10.0, 20.0, 20.0);
    protected Boolean value = null;
    protected transient Set<ActionListener> actionListeners = new HashSet<ActionListener>();

    @INode.SyncField(value={"value"})
    public void setValue(Boolean value) {
        this.value = value;
        if (this.component instanceof JToggleButton) {
            ((JToggleButton)this.component).setSelected(value == null ? false : value);
        }
    }

    @INode.SyncField(value={"transform"})
    public void setTransform(AffineTransform transform) {
        assert (transform != null);
        this.transform = transform;
        this.transform.translate(-10.0, -10.0);
    }

    @Override
    public void render(Graphics2D g2d) {
        if (this.component != null) {
            int width = (int)BOUNDS.getWidth();
            int height = (int)BOUNDS.getHeight();
            AffineTransform ot = g2d.getTransform();
            double sx = 1.0;
            double sy = 1.0;
            if (this.transform != null) {
                g2d.transform(this.transform);
                sx = g2d.getTransform().getScaleX();
                sy = g2d.getTransform().getScaleY();
                g2d.scale(1.0 / sx, 1.0 / sy);
            }
            ((JToggleButton)this.component).setSize((int)((double)width * sx), (int)((double)height * sy));
            ((JToggleButton)this.component).paint(g2d);
            g2d.setTransform(ot);
        }
    }

    public static Shape getOutline() {
        return BOUNDS;
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return BOUNDS;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Boolean s = ((JToggleButton)this.component).isSelected();
        this.performAction(new ActionEvent(new DummyComponent(), 1001, String.valueOf(s)));
    }

    @INode.ServerSide
    protected void performAction(ActionEvent e) {
        for (ActionListener listener : this.actionListeners) {
            listener.actionPerformed(e);
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionListeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(l);
    }

    @Override
    public void init() {
        Boolean s = this.value == null ? false : this.value;
        this.component = new JToggleButton(null, null, s);
        ((JToggleButton)this.component).setCursor(new Cursor(12));
        ((JToggleButton)this.component).addActionListener(this);
        ((JToggleButton)this.component).setBackground(Color.RED);
        super.init();
    }
}

