/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.nodes;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

import org.simantics.scenegraph.ExportableWidget.OutputWidget;
import org.simantics.scenegraph.g2d.G2DNode;

@OutputWidget("text")
public class TextNode extends G2DNode {

    private static final long serialVersionUID = 8508750881358776559L;

    protected Rectangle2D bounds = null;
    protected String      text   = null;
    protected Font        font   = null;
    protected Color       color  = Color.BLACK;

    @SyncField("bounds")
    public void setBounds(Rectangle2D bounds) {
        this.bounds = bounds;
    }

    @SyncField("font")
    public void setFont(Font font) {
        this.font = font;
    }
    
    @SyncField("text")
    public void setText(String text) {
        this.text = text;
    }
    
    public String getText() {
        return this.text;
    }

    @SyncField("color")
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public void render(Graphics2D g) {
        if (text == null || bounds == null || font == null || color == null)
            return;
        
//        PdfWriter writer = (PdfWriter) g.getRenderingHint(G2DPDFRenderingHints.KEY_PDF_WRITER);
//        if ( writer == null ) {
        	// Write to Graphics2D
	        g.setFont(font);
	        g.setColor(color);
	
	        FontMetrics fm = 	g.getFontMetrics(font);
	        Rectangle2D rect = 	fm.getStringBounds(text, g);
	        float x = (float) ((bounds.getWidth()  - rect.getWidth())/2 + bounds.getMinX());
	        float y = (float) ((bounds.getHeight() - rect.getHeight())/2 + bounds.getMinY());
	        
	        AffineTransform at = g.getTransform();
	        g.transform(getTransform());
	        g.drawString(text, x, (float)(y+rect.getHeight()));
	        g.setTransform(at);
//        } else {
	        /*
			try {
	        	// Write to PDF
	            FontMapper mapper = (FontMapper) g.getRenderingHint(G2DPDFRenderingHints.KEY_PDF_FONTMAPPER);
	            //text.setBorderStyle(PdfBorderDictionary.STYLE_BEVELED);
	            AffineTransform at = g.getTransform();
		        FontMetrics fm = 	g.getFontMetrics(font);
		        Rectangle2D rect = 	fm.getStringBounds(text, g);
		        float x = (float) ((bounds.getWidth()  - rect.getWidth())/2 + bounds.getMinX());
		        float y = (float) ((bounds.getHeight() - rect.getHeight())/2 + bounds.getMinY());
		        
	            Point2D pt1 = at.transform(new Point2D.Float(x, y+(float)rect.getHeight()), null);
	            Point2D pt2 = at.transform(new Point2D.Float(x+(float)rect.getWidth(), y), null);
	        	Rectangle rectangle = new Rectangle(
	        			(float) pt1.getX(), 
	        			(float) pt1.getY(), 
	        			(float) pt2.getX(), 
	        			(float) pt2.getY()); 
	            TextField text = new TextField(writer, rectangle, "approvedBy");
	            text.setText(this.text);
	            text.setFont(mapper.awtToPdf(font));
	            text.setFontSize(0);
	            text.setAlignment(Element.ALIGN_LEFT);
	            text.setRotation(90);
	            text.setOptions(TextField.READ_ONLY);
	            PdfFormField field = text.getTextField();
	            writer.addAnnotation(field);
			} catch (IOException e) {
				e.printStackTrace();
			} catch (DocumentException e) {
				e.printStackTrace();
			}
        	*/
//        }
    }

//    @Override
//    public Rectangle2D getBoundsInLocal() {
//        return bounds;
//    }
    
    @Override
    public Rectangle2D getBoundsInLocal() {
        return bounds;
    }
    
    @Override
    public Rectangle2D getBounds() {
        return null;
    }
    
}
