/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.events.command;

import java.awt.geom.Point2D;

/**
 * @author Tuukka Lehtonen
 */
public class ShowPopup extends Command {

    private static final long serialVersionUID = 8693557919059826895L;

    private Point2D controlPosition;

    public ShowPopup(Point2D controlPosition) {
        super("showPopup");
        this.controlPosition = controlPosition;
    }

    public Point2D getControlPosition() {
        return controlPosition;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = super.hashCode();
        result = prime * result + ((controlPosition == null) ? 0 : controlPosition.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (!super.equals(obj))
            return false;
        if (getClass() != obj.getClass())
            return false;
        ShowPopup other = (ShowPopup) obj;
        if (controlPosition == null) {
            if (other.controlPosition != null)
                return false;
        } else if (!controlPosition.equals(other.controlPosition))
            return false;
        return true;
    }

    @Override
    public String toString() {
        return super.toString() + "(" + controlPosition + ")";
    }

}
