/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.profile.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;

public class AvailableProfiles
extends ResourceRead<List<NamedResource>> {
    protected AvailableProfiles(Resource runtimeDiagram) {
        super(runtimeDiagram);
    }

    public List<NamedResource> perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        String indexURI = (String)graph.getPossibleRelatedValue(this.resource, DIA.RuntimeDiagram_HasModelURI);
        if (indexURI == null) {
            return Collections.emptyList();
        }
        Resource index = graph.getPossibleResource(indexURI);
        if (index == null) {
            return Collections.emptyList();
        }
        Instances query = (Instances)graph.adapt(DIA.Profile, Instances.class);
        ArrayList<NamedResource> result = new ArrayList<NamedResource>();
        for (Resource profile : query.find(graph, index)) {
            if (graph.hasStatement(profile, L0.Abstract)) continue;
            String name = (String)graph.getRelatedValue(profile, L0.HasName, (Binding)Bindings.STRING);
            result.add(new NamedResource(name, profile));
        }
        return result;
    }
}

