/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.profile.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Stack;
import org.simantics.basicexpression.analysis.DepthFirstAdapter;
import org.simantics.basicexpression.node.AAddressValue;
import org.simantics.basicexpression.node.AConstantValue;
import org.simantics.basicexpression.node.ADivMultiplicative;
import org.simantics.basicexpression.node.AFunctionPrimary;
import org.simantics.basicexpression.node.AMultMultiplicative;
import org.simantics.basicexpression.node.APlusExpression;
import org.simantics.basicexpression.node.ARangeValue;
import org.simantics.basicexpression.node.ASequenceArgList;
import org.simantics.basicexpression.node.ASingleArgList;
import org.simantics.basicexpression.node.AStringValue;
import org.simantics.basicexpression.node.AVariablePrimary;
import org.simantics.basicexpression.node.PArgList;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Valuations;
import org.simantics.layer0.Layer0;
import org.simantics.scl.reflection.OntologyVersions;

public class MappedPropertyStyleEvaluator
extends DepthFirstAdapter {
    final ReadGraph graph;
    final Layer0 b;
    final Resource component;
    Stack<Object> stack = new Stack();
    HashMap<String, Function> builtins = new HashMap();

    public MappedPropertyStyleEvaluator(ReadGraph graph, Resource element) throws DatabaseException {
        this.graph = graph;
        this.b = Layer0.getInstance((ReadGraph)graph);
        String uri = OntologyVersions.getInstance().currentVersion("http://www.simantics.org/Modeling-0.0/ElementToComponent");
        Resource toComponent = graph.getResource(uri);
        this.component = graph.getPossibleObject(element, toComponent);
    }

    public Object getResult() {
        if (this.stack.isEmpty()) {
            return null;
        }
        return this.stack.pop();
    }

    public void outAConstantValue(AConstantValue node) {
        this.stack.push(Double.valueOf(node.toString()));
    }

    public void outAStringValue(AStringValue node) {
        String value = node.toString();
        this.stack.push(value.substring(1, value.length() - 2).trim());
    }

    public void outAVariablePrimary(AVariablePrimary node) {
        try {
            Valuations vs = (Valuations)this.graph.adapt(this.component, Valuations.class);
            if (vs == null) {
                this.stack.push("No Variables for mapped component.");
                return;
            }
            Resource valueResource = vs.getValue(this.graph, null, "BaseRealization", node.toString().trim());
            if (valueResource == null) {
                this.stack.push("Invalid value identifier based on  '" + node.toString().trim() + "'");
                return;
            }
            Object value = this.graph.getValue(valueResource);
            this.stack.push(value);
        }
        catch (DatabaseException e) {
            this.stack.push(e.toString());
        }
    }

    public void outAAddressValue(AAddressValue node) {
        this.stack.push("&" + node.getRange().toString());
    }

    public void outARangeValue(ARangeValue node) {
    }

    private double extractValue(Object o) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String) {
            return Double.valueOf((String)o);
        }
        return Double.NaN;
    }

    public void outAPlusExpression(APlusExpression node) {
        Object o2 = this.stack.pop();
        Object o1 = this.stack.pop();
        if (o1 instanceof String) {
            this.stack.push(o1.toString() + o2.toString());
        } else {
            double d1 = this.extractValue(o1);
            double d2 = this.extractValue(o2);
            this.stack.push(d1 + d2);
        }
    }

    public void outAMultMultiplicative(AMultMultiplicative node) {
        Object o1 = this.stack.pop();
        Object o2 = this.stack.pop();
        double d1 = this.extractValue(o1);
        double d2 = this.extractValue(o2);
        this.stack.push(d1 * d2);
    }

    public void outADivMultiplicative(ADivMultiplicative node) {
        Object o2 = this.stack.pop();
        Object o1 = this.stack.pop();
        System.out.println("div " + String.valueOf(o1) + " " + String.valueOf(o2));
        double d1 = this.extractValue(o1);
        double d2 = this.extractValue(o2);
        this.stack.push(d1 / d2);
    }

    int countArguments(PArgList args) {
        if (args == null) {
            return 0;
        }
        if (args instanceof ASingleArgList) {
            return 1;
        }
        ASequenceArgList seq = (ASequenceArgList)args;
        return 1 + this.countArguments(seq.getArgList());
    }

    public void outAFunctionPrimary(AFunctionPrimary node) {
        String functionName = node.getFunc().getText().replace("(", "");
        Function function = this.builtins.get(functionName);
        if (function != null) {
            LinkedList<Object> args = new LinkedList<Object>();
            int argc = this.countArguments(node.getArgList());
            int i = 0;
            while (i < argc) {
                args.addFirst(this.stack.pop());
                ++i;
            }
            try {
                Object result = function.evaluate(args);
                this.stack.push(result);
            }
            catch (ApplicationException e) {
                e.printStackTrace();
                this.stack.push(null);
            }
            return;
        }
    }

    public static class ApplicationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ApplicationException(String message) {
            super(message);
        }
    }

    public static interface Function {
        public Object evaluate(Collection<Object> var1) throws ApplicationException;
    }
}

