/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.profile.common;

import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.NodeException;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.utils.InitValueSupport;
import org.simantics.scenegraph.utils.NodeUtil;

public class ProfileVariables {
    public static void init(INode node, Observer observer) {
        if (node instanceof InitValueSupport) {
            ((InitValueSupport)node).initValues();
        }
    }

    public static <N extends INode> N browseChild(INode node, String id) {
        String[] parts;
        if (id.isEmpty()) {
            return (N)node;
        }
        String[] stringArray = parts = id.split("\\.");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            node = "*".equals(part) ? NodeUtil.getFirstChild((INode)node) : NodeUtil.getChildById((INode)node, (String)part);
            if (node == null) {
                return null;
            }
            ++n2;
        }
        return (N)node;
    }

    public static void claimNodeProperty(INode node, String property, Object value, EvaluationContext evaluationContext) {
        if (node == null) {
            evaluationContext.update();
            return;
        }
        if (property.contains(".")) {
            String[] t = property.split("\\.");
            if (t.length == 2) {
                INode child;
                String child_name = t[0];
                String property_name = t[1];
                if (node instanceof G2DParentNode && (child = NodeUtil.findChildById((ParentNode)((G2DParentNode)node), (String)child_name)) != null) {
                    NodeUtil.setPropertyIfSupported((String)property_name, (Object)value, (INode)child);
                }
            }
        } else {
            NodeUtil.setPropertyIfSupported((String)property, (Object)value, (INode)node);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <N extends INode> N claimChild(INode node, String path, String name, Class<N> clazz, Observer observer) {
        N child = ProfileVariables.browseChild(node, path);
        if (child == null) {
            observer.exception(new NullPointerException("Scenegraph child node was not found: " + path));
            observer.update();
            return null;
        }
        INode existing = NodeUtil.getChildById(child, (String)name);
        if (existing != null) {
            if (clazz.isInstance(existing)) return (N)((INode)clazz.cast(existing));
            observer.exception(new ClassCastException("Class of existing child node (" + String.valueOf(existing.getClass()) + ") with path=" + path + " and name=" + name + " is invalid, requested " + String.valueOf(clazz)));
            return null;
        }
        if (child instanceof ParentNode) {
            existing = (INode)((ParentNode)child).addNode(name, clazz);
            return (N)((INode)clazz.cast(existing));
        }
        observer.exception((Throwable)new NodeException("Cannot claim child node for non-parent-node " + String.valueOf(child)));
        return null;
    }

    public static void denyChild(INode node, String path, String name) {
        Object child = ProfileVariables.browseChild(node, path);
        if (child == null) {
            return;
        }
        if (child instanceof ParentNode) {
            ((ParentNode)child).removeNode(name);
        }
    }

    public static void denyChild(INode node, String name) {
        ProfileVariables.denyChild(node, "", name);
    }

    public static void denyChildren(INode node, String prefix) {
        if (node instanceof ParentNode) {
            ParentNode parent = (ParentNode)node;
            for (String childId : NodeUtil.filterDirectChildIds((ParentNode)parent, (String)prefix)) {
                parent.removeNode(childId);
            }
        }
    }
}

