package org.simantics.scenegraph.profile.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.diagram.stubs.DiagramResource;

public class ProfileEntryContributions extends ResourceRead<Collection<Resource>>{

	protected ProfileEntryContributions(Resource runtimeDiagram) {
		super(runtimeDiagram);
	}

	@Override
	public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {

		DiagramResource DIA = DiagramResource.getInstance(graph);

		String indexURI = graph.getPossibleRelatedValue(resource, DIA.RuntimeDiagram_HasModelURI);
		if (indexURI == null)
			return Collections.emptyList();

		Resource index = graph.getPossibleResource(indexURI);
		if (index == null)
			return Collections.emptyList();

		Instances query = graph.adapt(DIA.ProfileEntryContribution, Instances.class);

		ArrayList<Resource> result = new ArrayList<>();
		for(Resource contribution : query.find(graph, index)) {
			for(Resource entry : graph.getObjects(contribution, DIA.ProfileEntryContribution_HasEntry)) {
				result.add(entry);	
			}
			
		}

		return result;

	}

}