package org.simantics.scenegraph.loader;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.adaption.SimpleContextualAdapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.Variable;

public class ScenegraphVariableAdapter extends SimpleContextualAdapter<Variable, Variable> {

	@Override
	public Variable adapt(ReadGraph g, Resource source, Variable context) throws DatabaseException {
		SceneGraphContext vc = ScenegraphLoaderUtils.getContext(g, context);
		if(vc != null)
			return new ScenegraphVariable(context, source, null, /*context.adapt(g, SceneGraphContext.class).getRuntime()*/ null);
		else
			return new StandardGraphChildVariable(context, null, source);
	}

}
