/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.loader;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Remover;
import org.simantics.db.layer0.adapter.impl.AbstractRemover;
import org.simantics.db.layer0.adapter.impl.EntityRemover;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.ontology.ScenegraphResources;

/**
 * A {@link Remover} implementation for removing SG.Node instances.
 * 
 * <p>
 * In addition to removing the node instance itself, this remover first tries to
 * remove the node from the <em>children</em> linked list of its possible parent
 * node.
 * 
 * @author Tuukka Lehtonen
 */
public class NodeRemover extends AbstractRemover {

    private static final boolean DEBUG = false;

    public NodeRemover(Resource node) throws DatabaseException {
        super(node);
    }

    @Override
    public void remove(WriteGraph graph) throws DatabaseException {
        if (DEBUG)
            System.out.println(this + " removing scene graph node");

        Layer0 L0 = Layer0.getInstance(graph);
        ScenegraphResources SG = ScenegraphResources.getInstance(graph);

        // 1. Remove node from possible parent resource linked list.
        for (Resource parentNode : graph.getObjects(resource, L0.PartOf)) {
            for (Resource list : graph.getObjects(parentNode, SG.Node_children)) {
                ListUtils.removeElement(graph, list, resource);
            }
        }

        // 2. Delete node itself
        EntityRemover.remove(graph, resource);
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + resource;
    }

}
