/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.management;

import java.util.regex.Matcher;
import org.simantics.project.management.GraphBundle;

public class GraphBundleRef {
    public final String id;
    public final int major;

    public static GraphBundleRef of(String versionedId) {
        Matcher m = GraphBundle.VERSIONED_ID_PATTERN.matcher(versionedId);
        String id = m.group(1);
        int major = Integer.valueOf(m.group(2));
        return new GraphBundleRef(id, major);
    }

    public static GraphBundleRef of(GraphBundle bundle) {
        return new GraphBundleRef(bundle.getId(), bundle.getMajor());
    }

    public GraphBundleRef(String id, int major) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.major = major;
    }

    public int hashCode() {
        return this.id.hashCode() + this.major;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GraphBundleRef)) {
            return false;
        }
        GraphBundleRef other = (GraphBundleRef)obj;
        return other.id.equals(this.id) && other.major == this.major;
    }

    public String toString() {
        return this.id + "/" + this.major;
    }
}

