/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.management;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Supplier;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.project.management.GraphBundle;

public class GraphBundleEx
extends GraphBundle
implements IVersionedId {
    public static final SimpleDateFormat QUALIFIER_FORMAT = new SimpleDateFormat("yyyyMMddHHmm");
    VersionedId vid;

    public static GraphBundleEx extend(GraphBundle bundle) {
        return new GraphBundleEx(bundle);
    }

    public static Version buildQualifier(Version v) {
        String qualifier = v.getSegment(3).toString();
        if (!qualifier.equals("qualifier")) {
            return v;
        }
        int major = (Integer)v.getSegment(0);
        int minor = (Integer)v.getSegment(1);
        int micro = (Integer)v.getSegment(2);
        qualifier = QUALIFIER_FORMAT.format(new Date());
        return Version.createOSGi((int)major, (int)minor, (int)micro, (String)qualifier);
    }

    public static VersionedId buildQualifier(IVersionedId vid) {
        Version v = vid.getVersion();
        String id = vid.getId();
        return new VersionedId(id, GraphBundleEx.buildQualifier(v));
    }

    GraphBundleEx(GraphBundle e) {
        this.graphSource = e.graphSource;
        this.graph = e.graph;
        this.resource = e.resource;
        this.hashcode = e.hashcode;
        this.id = e.id;
        this.major = e.major;
        this.minor = e.minor;
        this.service = e.service;
        this.qualifier = e.qualifier;
        this.resourceArray = e.resourceArray;
        this.name = e.name;
        this.vid = new VersionedId(this.id, Version.createOSGi((int)this.major, (int)this.minor, (int)this.service, (String)this.qualifier));
        this.immutable = e.immutable;
    }

    public GraphBundleEx(String name, TransferableGraph1 data, String versionedId) throws RuntimeBindingException {
        super(name, data, versionedId);
        Version v = Version.createOSGi((int)this.major, (int)this.minor, (int)this.service, (String)this.qualifier);
        this.vid = new VersionedId(this.id, v);
    }

    public GraphBundleEx(String name, TransferableGraph1 data, String id, String version) throws RuntimeBindingException {
        super(name, data, id, version);
        Version v = Version.createOSGi((int)this.major, (int)this.minor, (int)this.service, (String)this.qualifier);
        this.vid = new VersionedId(id, v);
    }

    public GraphBundleEx(String name, TransferableGraph1 data, String id, Version version) throws RuntimeBindingException {
        super(name, data, id, String.valueOf(version.getSegment(0)) + "." + String.valueOf(version.getSegment(1)) + "." + String.valueOf(version.getSegment(2)) + "." + String.valueOf(version.getSegment(3)));
        Version v = Version.createOSGi((int)this.major, (int)this.minor, (int)this.service, (String)this.qualifier);
        this.vid = new VersionedId(id, v);
    }

    public GraphBundleEx(String name, TransferableGraph1 data, IVersionedId vid, boolean isImmutable) throws RuntimeBindingException {
        super(name, data, vid.getId(), vid.getVersion().getSegment(0).toString() + "." + vid.getVersion().getSegment(1).toString() + "." + vid.getVersion().getSegment(2).toString() + "." + vid.getVersion().getSegment(3).toString());
        this.vid = new VersionedId(this.id, vid.getVersion());
        this.immutable = isImmutable;
    }

    public GraphBundleEx(String name, Supplier<TransferableGraph1> source, int hashValue, IVersionedId vid, boolean isImmutable) throws RuntimeBindingException {
        super(name, source, hashValue, vid.getId(), vid.getVersion().getSegment(0).toString() + "." + vid.getVersion().getSegment(1).toString() + "." + vid.getVersion().getSegment(2).toString() + "." + vid.getVersion().getSegment(3).toString());
        this.vid = new VersionedId(this.id, vid.getVersion());
        this.immutable = isImmutable;
    }

    public GraphBundleEx(String name, TransferableGraph1 data, IVersionedId vid) throws RuntimeBindingException {
        this(name, data, vid, true);
    }

    public void build() {
        this.vid = GraphBundleEx.buildQualifier((IVersionedId)this.vid);
        this.qualifier = this.vid.getVersion().getSegment(3).toString();
    }

    public VersionedId getVid() {
        return this.vid;
    }

    public Version getVersion() {
        return this.vid.getVersion();
    }
}

