/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project;

import java.util.Set;
import org.simantics.project.GroupFilter;
import org.simantics.project.features.registry.GroupReference;

public final class GroupFilters {
    private static final GroupFilter ACCEPT_ALL = GroupFilters.constant(true);
    private static final GroupFilter DENY_ALL = GroupFilters.constant(false);

    public static GroupFilter constant(final boolean answer) {
        return new GroupFilter(){

            @Override
            public boolean accept(GroupReference ref) {
                return answer;
            }
        };
    }

    public static GroupFilter acceptAll() {
        return ACCEPT_ALL;
    }

    public static GroupFilter denyAll() {
        return DENY_ALL;
    }

    public static GroupFilter containsEqual(final Set<GroupReference> refs) {
        return new GroupFilter(){

            @Override
            public boolean accept(GroupReference ref) {
                return refs.contains(ref);
            }
        };
    }

    public static GroupFilter includesVersion(final Set<GroupReference> refs) {
        return new GroupFilter(){

            @Override
            public boolean accept(GroupReference range) {
                for (GroupReference ref : refs) {
                    if (!range.includes(ref)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

