package org.simantics.project.ontology;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class ProjectResource {
    
    public final Resource Contributions;
    public final Resource Contributions_ActiveModelVisualization;
    public final Resource Contributions_ActiveRunVisualization;
    public final Resource Contributions_ExperimentImageRule;
    public final Resource Contributions_Migrate;
    public final Resource Contributions_ModelChildren;
    public final Resource Contributions_ModelImageRule;
    public final Resource Contributions_RunImageRule;
    public final Resource Contributions_StandardNameLabelRule;
    public final Resource DefaultProjectActionContext;
    public final Resource DefaultProjectBrowseContext;
    public final Resource DefaultProjectVisualizationContext;
    public final Resource FeatureSpec;
    public final Resource HasFeature;
    public final Resource HasFeature_Inverse;
    public final Resource HasGroupId;
    public final Resource HasGroupId_Inverse;
    public final Resource IsRequired;
    public final Resource IsRequired_Inverse;
    public final Resource MainToolbarActionContext;
    public final Resource NamespaceRequirement;
    public final Resource Project;
    public final Resource ProjectActionContext;
    public final Resource ProjectActionContext_Actions;
    public final Resource ProjectActionContext_Actions_Migrate;
    public final Resource ProjectActionContext_Tests;
    public final Resource ProjectActionContext_Tests_IsMigrationPossible;
    public final Resource ProjectBrowseContext;
    public final Resource ProjectBrowseContext_ActiveLabelDecorationRule;
    public final Resource ProjectBrowseContext_Images;
    public final Resource ProjectBrowseContext_Images_Experiment;
    public final Resource ProjectBrowseContext_Images_Folder;
    public final Resource ProjectBrowseContext_Images_Model;
    public final Resource ProjectBrowseContext_Images_Run;
    public final Resource ProjectBrowseContext_RunLabelRule;
    public final Resource ProjectDoubleClickActionContext;
    public final Resource ProjectFileMenuActionContext;
    public final Resource ProjectFileMenuNewActionContext;
    public final Resource ProjectType;
    public final Resource RequiresNamespace;
    public final Resource RequiresNamespace_Inverse;
        
    public static class URIs {
        public static final String Contributions = "http://www.simantics.org/Project-1.2/Contributions";
        public static final String Contributions_ActiveModelVisualization = "http://www.simantics.org/Project-1.2/Contributions/ActiveModelVisualization";
        public static final String Contributions_ActiveRunVisualization = "http://www.simantics.org/Project-1.2/Contributions/ActiveRunVisualization";
        public static final String Contributions_ExperimentImageRule = "http://www.simantics.org/Project-1.2/Contributions/ExperimentImageRule";
        public static final String Contributions_Migrate = "http://www.simantics.org/Project-1.2/Contributions/Migrate";
        public static final String Contributions_ModelChildren = "http://www.simantics.org/Project-1.2/Contributions/ModelChildren";
        public static final String Contributions_ModelImageRule = "http://www.simantics.org/Project-1.2/Contributions/ModelImageRule";
        public static final String Contributions_RunImageRule = "http://www.simantics.org/Project-1.2/Contributions/RunImageRule";
        public static final String Contributions_StandardNameLabelRule = "http://www.simantics.org/Project-1.2/Contributions/StandardNameLabelRule";
        public static final String DefaultProjectActionContext = "http://www.simantics.org/Project-1.2/DefaultProjectActionContext";
        public static final String DefaultProjectBrowseContext = "http://www.simantics.org/Project-1.2/DefaultProjectBrowseContext";
        public static final String DefaultProjectVisualizationContext = "http://www.simantics.org/Project-1.2/DefaultProjectVisualizationContext";
        public static final String FeatureSpec = "http://www.simantics.org/Project-1.2/FeatureSpec";
        public static final String HasFeature = "http://www.simantics.org/Project-1.2/HasFeature";
        public static final String HasFeature_Inverse = "http://www.simantics.org/Project-1.2/HasFeature/Inverse";
        public static final String HasGroupId = "http://www.simantics.org/Project-1.2/HasGroupId";
        public static final String HasGroupId_Inverse = "http://www.simantics.org/Project-1.2/HasGroupId/Inverse";
        public static final String IsRequired = "http://www.simantics.org/Project-1.2/IsRequired";
        public static final String IsRequired_Inverse = "http://www.simantics.org/Project-1.2/IsRequired/Inverse";
        public static final String MainToolbarActionContext = "http://www.simantics.org/Project-1.2/MainToolbarActionContext";
        public static final String NamespaceRequirement = "http://www.simantics.org/Project-1.2/NamespaceRequirement";
        public static final String Project = "http://www.simantics.org/Project-1.2/Project";
        public static final String ProjectActionContext = "http://www.simantics.org/Project-1.2/ProjectActionContext";
        public static final String ProjectActionContext_Actions = "http://www.simantics.org/Project-1.2/ProjectActionContext/Actions";
        public static final String ProjectActionContext_Actions_Migrate = "http://www.simantics.org/Project-1.2/ProjectActionContext/Actions/Migrate";
        public static final String ProjectActionContext_Tests = "http://www.simantics.org/Project-1.2/ProjectActionContext/Tests";
        public static final String ProjectActionContext_Tests_IsMigrationPossible = "http://www.simantics.org/Project-1.2/ProjectActionContext/Tests/IsMigrationPossible";
        public static final String ProjectBrowseContext = "http://www.simantics.org/Project-1.2/ProjectBrowseContext";
        public static final String ProjectBrowseContext_ActiveLabelDecorationRule = "http://www.simantics.org/Project-1.2/ProjectBrowseContext/ActiveLabelDecorationRule";
        public static final String ProjectBrowseContext_Images = "http://www.simantics.org/Project-1.2/ProjectBrowseContext/Images";
        public static final String ProjectBrowseContext_Images_Experiment = "http://www.simantics.org/Project-1.2/ProjectBrowseContext/Images/Experiment";
        public static final String ProjectBrowseContext_Images_Folder = "http://www.simantics.org/Project-1.2/ProjectBrowseContext/Images/Folder";
        public static final String ProjectBrowseContext_Images_Model = "http://www.simantics.org/Project-1.2/ProjectBrowseContext/Images/Model";
        public static final String ProjectBrowseContext_Images_Run = "http://www.simantics.org/Project-1.2/ProjectBrowseContext/Images/Run";
        public static final String ProjectBrowseContext_RunLabelRule = "http://www.simantics.org/Project-1.2/ProjectBrowseContext/RunLabelRule";
        public static final String ProjectDoubleClickActionContext = "http://www.simantics.org/Project-1.2/ProjectDoubleClickActionContext";
        public static final String ProjectFileMenuActionContext = "http://www.simantics.org/Project-1.2/ProjectFileMenuActionContext";
        public static final String ProjectFileMenuNewActionContext = "http://www.simantics.org/Project-1.2/ProjectFileMenuNewActionContext";
        public static final String ProjectType = "http://www.simantics.org/Project-1.2/ProjectType";
        public static final String RequiresNamespace = "http://www.simantics.org/Project-1.2/RequiresNamespace";
        public static final String RequiresNamespace_Inverse = "http://www.simantics.org/Project-1.2/RequiresNamespace/Inverse";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public ProjectResource(ReadGraph graph) {
        Contributions = getResourceOrNull(graph, URIs.Contributions);
        Contributions_ActiveModelVisualization = getResourceOrNull(graph, URIs.Contributions_ActiveModelVisualization);
        Contributions_ActiveRunVisualization = getResourceOrNull(graph, URIs.Contributions_ActiveRunVisualization);
        Contributions_ExperimentImageRule = getResourceOrNull(graph, URIs.Contributions_ExperimentImageRule);
        Contributions_Migrate = getResourceOrNull(graph, URIs.Contributions_Migrate);
        Contributions_ModelChildren = getResourceOrNull(graph, URIs.Contributions_ModelChildren);
        Contributions_ModelImageRule = getResourceOrNull(graph, URIs.Contributions_ModelImageRule);
        Contributions_RunImageRule = getResourceOrNull(graph, URIs.Contributions_RunImageRule);
        Contributions_StandardNameLabelRule = getResourceOrNull(graph, URIs.Contributions_StandardNameLabelRule);
        DefaultProjectActionContext = getResourceOrNull(graph, URIs.DefaultProjectActionContext);
        DefaultProjectBrowseContext = getResourceOrNull(graph, URIs.DefaultProjectBrowseContext);
        DefaultProjectVisualizationContext = getResourceOrNull(graph, URIs.DefaultProjectVisualizationContext);
        FeatureSpec = getResourceOrNull(graph, URIs.FeatureSpec);
        HasFeature = getResourceOrNull(graph, URIs.HasFeature);
        HasFeature_Inverse = getResourceOrNull(graph, URIs.HasFeature_Inverse);
        HasGroupId = getResourceOrNull(graph, URIs.HasGroupId);
        HasGroupId_Inverse = getResourceOrNull(graph, URIs.HasGroupId_Inverse);
        IsRequired = getResourceOrNull(graph, URIs.IsRequired);
        IsRequired_Inverse = getResourceOrNull(graph, URIs.IsRequired_Inverse);
        MainToolbarActionContext = getResourceOrNull(graph, URIs.MainToolbarActionContext);
        NamespaceRequirement = getResourceOrNull(graph, URIs.NamespaceRequirement);
        Project = getResourceOrNull(graph, URIs.Project);
        ProjectActionContext = getResourceOrNull(graph, URIs.ProjectActionContext);
        ProjectActionContext_Actions = getResourceOrNull(graph, URIs.ProjectActionContext_Actions);
        ProjectActionContext_Actions_Migrate = getResourceOrNull(graph, URIs.ProjectActionContext_Actions_Migrate);
        ProjectActionContext_Tests = getResourceOrNull(graph, URIs.ProjectActionContext_Tests);
        ProjectActionContext_Tests_IsMigrationPossible = getResourceOrNull(graph, URIs.ProjectActionContext_Tests_IsMigrationPossible);
        ProjectBrowseContext = getResourceOrNull(graph, URIs.ProjectBrowseContext);
        ProjectBrowseContext_ActiveLabelDecorationRule = getResourceOrNull(graph, URIs.ProjectBrowseContext_ActiveLabelDecorationRule);
        ProjectBrowseContext_Images = getResourceOrNull(graph, URIs.ProjectBrowseContext_Images);
        ProjectBrowseContext_Images_Experiment = getResourceOrNull(graph, URIs.ProjectBrowseContext_Images_Experiment);
        ProjectBrowseContext_Images_Folder = getResourceOrNull(graph, URIs.ProjectBrowseContext_Images_Folder);
        ProjectBrowseContext_Images_Model = getResourceOrNull(graph, URIs.ProjectBrowseContext_Images_Model);
        ProjectBrowseContext_Images_Run = getResourceOrNull(graph, URIs.ProjectBrowseContext_Images_Run);
        ProjectBrowseContext_RunLabelRule = getResourceOrNull(graph, URIs.ProjectBrowseContext_RunLabelRule);
        ProjectDoubleClickActionContext = getResourceOrNull(graph, URIs.ProjectDoubleClickActionContext);
        ProjectFileMenuActionContext = getResourceOrNull(graph, URIs.ProjectFileMenuActionContext);
        ProjectFileMenuNewActionContext = getResourceOrNull(graph, URIs.ProjectFileMenuNewActionContext);
        ProjectType = getResourceOrNull(graph, URIs.ProjectType);
        RequiresNamespace = getResourceOrNull(graph, URIs.RequiresNamespace);
        RequiresNamespace_Inverse = getResourceOrNull(graph, URIs.RequiresNamespace_Inverse);
    }
    
    public static ProjectResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        ProjectResource ret = session.peekService(ProjectResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new ProjectResource(qc.getIndependentGraph(graph));
            session.registerService(ProjectResource.class, ret);
        }
        return ret;
    }
    
    public static ProjectResource getInstance(RequestProcessor session) throws DatabaseException {
        ProjectResource ret = session.peekService(ProjectResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<ProjectResource>() {
                public ProjectResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new ProjectResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(ProjectResource.class, ret);
        }
        return ret;
    }
    
}

