/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.graph.schema;

import gnu.trove.map.hash.THashMap;
import java.util.Stack;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.graph.schema.AdaptedLinkType;
import org.simantics.objmap.graph.schema.ILinkType;
import org.simantics.objmap.graph.schema.IMappingSchema;
import org.simantics.objmap.graph.schema.SimpleLinkType;

public class SimpleSchema
implements IMappingSchema<Resource, Object> {
    THashMap<Resource, ILinkType<Resource, Object>> domainLinkTypes = new THashMap();
    THashMap<Class<?>, ILinkType<Resource, Object>> rangeLinkTypes = new THashMap();

    public void addLinkType(SimpleLinkType<Object> linkType) {
        this.domainLinkTypes.put((Object)linkType.domainType, linkType);
        this.rangeLinkTypes.put(linkType.rangeType, linkType);
    }

    public void addLinkType(AdaptedLinkType<Object> linkType) {
        this.domainLinkTypes.put((Object)linkType.domainType, linkType);
        this.rangeLinkTypes.put(linkType.rangeType, linkType);
    }

    @Override
    public ILinkType<Resource, Object> linkTypeOfDomainElement(ReadGraph g, Resource element) throws MappingException {
        try {
            for (Resource type : g.getTypes(element)) {
                ILinkType linkType = (ILinkType)this.domainLinkTypes.get((Object)type);
                if (linkType == null) continue;
                return linkType;
            }
            throw new MappingException("Didn't find a link type for " + NameUtils.getSafeName((ReadGraph)g, (Resource)element) + ".");
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }

    @Override
    public ILinkType<Resource, Object> linkTypeOfRangeElement(Object element) throws MappingException {
        ILinkType type = (ILinkType)this.rangeLinkTypes.get(element.getClass());
        if (type == null) {
            Class clazz;
            Stack clazzes = new Stack();
            Class<?>[] classArray = element.getClass().getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                clazz = classArray[n2];
                clazzes.add(clazz);
                ++n2;
            }
            clazzes.add(element.getClass().getSuperclass());
            while (!clazzes.isEmpty()) {
                clazz = (Class)clazzes.pop();
                type = (ILinkType)this.rangeLinkTypes.get((Object)clazz);
                if (type != null) {
                    return type;
                }
                Class<?>[] classArray2 = clazz.getInterfaces();
                int n3 = classArray2.length;
                n = 0;
                while (n < n3) {
                    Class<?> c = classArray2[n];
                    clazzes.add(c);
                    ++n;
                }
            }
            throw new MappingException("Didn't find a link type for " + String.valueOf(element.getClass()) + ".");
        }
        return type;
    }
}

