/*******************************************************************************
 * Copyright (c) 2012, 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.rules.factory;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.bidirectional.IBidirectionalMappingRule;

public interface IGetSetRuleFactory<Domain,Range> {
	IBidirectionalMappingRule<Domain, Range> create(ReadGraph g, Annotation annotation, Method getter, Method setter) throws DatabaseException;
	boolean isSetter(Annotation getterAnnotation, Annotation annotation);
}
